using System;
using System.Data;
using System.Text;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using gov.va.med.vbecs.Common;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmPendingTaskList
	/// </summary>
	public class FrmPendingTaskList : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private FrmTransfusionReactionWorkup _frmTrw;

		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.TabControl tabPTL;
		private System.Windows.Forms.Panel pnlDiagTest;
		private System.Windows.Forms.Panel pnlDiagSearch;
		private System.Windows.Forms.Panel pnlDiagDates;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.ColumnHeader columnHeader12;
		private System.Windows.Forms.ColumnHeader columnHeader14;
		private System.Windows.Forms.ColumnHeader columnHeader15;
		private System.Windows.Forms.ColumnHeader columnHeader16;
		private System.Windows.Forms.ColumnHeader columnHeader17;
		private System.Windows.Forms.ColumnHeader columnHeader18;
		private System.Windows.Forms.ColumnHeader columnHeader21;
		private System.Windows.Forms.ColumnHeader columnHeader22;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.GroupBox grpComponentOrders;
		private System.Windows.Forms.TabPage pageDiagTests;
		private System.Windows.Forms.GroupBox grpDiagTests;
		private System.Windows.Forms.CheckedListBox lstDiagTest;
		private System.Windows.Forms.Label lblDiagTest;
		private System.Windows.Forms.GroupBox grpComponentPTL;
		private System.Windows.Forms.GroupBox grpDiagPTL;
		private System.Windows.Forms.ListView lvDiagPTL;
		private System.Windows.Forms.TabPage pageComponentOrders;
		private System.Windows.Forms.ListView lvComponentPTL;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.Windows.Forms.ColumnHeader columnHeader25;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnDiagSearch;
		private System.Windows.Forms.Button btnDiagClear;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.CheckedListBox lstDiagPriority;
		private System.Windows.Forms.Label lblDiagPriority;
		private System.Windows.Forms.Panel pnlDiagTask;
		private System.Windows.Forms.CheckedListBox lstDiagTaskStatus;
		private System.Windows.Forms.Label lblDiagTaskStatus;
		private System.Windows.Forms.PictureBox picDiagScan;
		private System.Windows.Forms.TextBox txtDiagPatient;
		private System.Windows.Forms.Label lblDiagPatient;
		//CR 2056 replaced spcimen text box with BarcodeTextbox
		private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtDiagSpecimen;
		private System.Windows.Forms.Label lblDiagSpecimen;
		private System.Windows.Forms.Panel pnlCompTask;
		private System.Windows.Forms.CheckedListBox lstCompTaskStatus;
		private System.Windows.Forms.Label lblCompTaskStatus;
		private System.Windows.Forms.Panel pnlCompOrder;
		private System.Windows.Forms.CheckedListBox lstCompOrder;
		private System.Windows.Forms.Label lblCompOrder;
		private System.Windows.Forms.Panel pnlCompSearch;
		private System.Windows.Forms.PictureBox picCompScan;
		private System.Windows.Forms.TextBox txtCompPatient;
		private System.Windows.Forms.Label lblCompPatient;
		//CR 2056 replaced spcimen text box with BarcodeTextbox
		private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtCompSpecimen;
		private System.Windows.Forms.Label lblCompSpecimen;
		private System.Windows.Forms.Panel pnlCompPriority;
		private System.Windows.Forms.CheckedListBox lstCompPriority;
		private System.Windows.Forms.Label lblCompPriority;
		private System.Windows.Forms.Button btnCompClear;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnCompSearch;
		private System.Windows.Forms.Button btnSelectAllDiagTests;
		private System.Windows.Forms.Button btnDeselectAllDiagTests;
		private System.Windows.Forms.Button btnSelectAllDiagTaskStatus;
		private System.Windows.Forms.Button btnDeselectAllDiagTaskStatus;
		private System.Windows.Forms.Button btnSelectAllDiagPriority;
		private System.Windows.Forms.Button btnDeselectAllDiagPriority;
		private System.Windows.Forms.Button btnSelectAllCompOrders;
		private System.Windows.Forms.Button btnDeselectAllCompOrders;
		private System.Windows.Forms.Button btnSelectAllCompTaskStatus;
		private System.Windows.Forms.Button btnDeselectAllCompTaskStatus;
		private System.Windows.Forms.Button btnSelectAllCompPriority;
		private System.Windows.Forms.Button btnDeselectAllCompPriority;
		private System.ComponentModel.IContainer components = null;
		private DataTable _dtTestList;
		private DataTable _dtPriorityList;
		private DataTable _dtComponentClasses;
		private DataTable _dtTaskStatusList;
		private DataTable _dtAllTestingTaskList;
		private DataTable _dtAllComponentTaskList;
		private bool _disablePrintForTestingTask;
		private System.Windows.Forms.PrintDialog printDialog1;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnCancelOrders;
		private bool _disablePrintForCompTask;
		private int _notStartedItemsCheckedComp;
		private System.Windows.Forms.Label lblDiagCPRS;
		private System.Windows.Forms.TextBox txtDiagCPRS;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.TextBox txtCompCPRS;
		private System.Windows.Forms.Label lblCompCPRS;
		private System.Windows.Forms.ColumnHeader columnHeader13;
		private int _notStartedItemsCheckedDiag;
		private bool _diagSearchByOrderGroupNumber = false;
		private bool _compSearchByOrderGroupNumber = false;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="patientTesting"></param>
		public FrmPendingTaskList(bool patientTesting)
		{
			_disablePrintForTestingTask = false;
			_disablePrintForCompTask = false;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			_dtTaskStatusList = BOL.OrderedTest.GetTaskStatusList();
			PopulateTestList();
			PopulateTaskPriorities();
			PopulateComponentClasses();

			_dtAllComponentTaskList = BOL.OrderedComponent.GetComponentTaskList("");
			PopulateComponentTaskList(_dtAllComponentTaskList);

			_dtAllTestingTaskList = BOL.OrderedTest.GetTestingTaskList("");
			PopulateTestingTaskList(_dtAllTestingTaskList);

			if ((this._disablePrintForCompTask && this._disablePrintForTestingTask) || Common.Utility.IsDefaultPrinterConfigured == false)
			{
				this.btnPrint.Enabled = false;
			}
			else
			{
				this.btnPrint.Enabled = true;
			}

			if (patientTesting)
			{
				this.tabPTL.SelectedTab = this.pageDiagTests;
			}
			else
			{
				this.tabPTL.SelectedTab = this.pageComponentOrders;
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmPendingTaskList));
            this.btnCancel = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picImage = new System.Windows.Forms.PictureBox();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnPrint = new System.Windows.Forms.Button();
            this.tabPTL = new System.Windows.Forms.TabControl();
            this.pageDiagTests = new System.Windows.Forms.TabPage();
            this.grpDiagTests = new System.Windows.Forms.GroupBox();
            this.pnlDiagSearch = new System.Windows.Forms.Panel();
            this.txtDiagCPRS = new System.Windows.Forms.TextBox();
            this.lblDiagCPRS = new System.Windows.Forms.Label();
            this.picDiagScan = new System.Windows.Forms.PictureBox();
            this.txtDiagPatient = new System.Windows.Forms.TextBox();
            this.lblDiagPatient = new System.Windows.Forms.Label();
            this.txtDiagSpecimen = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
            this.lblDiagSpecimen = new System.Windows.Forms.Label();
            this.pnlDiagTest = new System.Windows.Forms.Panel();
            this.btnSelectAllDiagTests = new System.Windows.Forms.Button();
            this.btnDeselectAllDiagTests = new System.Windows.Forms.Button();
            this.lstDiagTest = new System.Windows.Forms.CheckedListBox();
            this.lblDiagTest = new System.Windows.Forms.Label();
            this.pnlDiagTask = new System.Windows.Forms.Panel();
            this.btnSelectAllDiagTaskStatus = new System.Windows.Forms.Button();
            this.btnDeselectAllDiagTaskStatus = new System.Windows.Forms.Button();
            this.lstDiagTaskStatus = new System.Windows.Forms.CheckedListBox();
            this.lblDiagTaskStatus = new System.Windows.Forms.Label();
            this.pnlDiagDates = new System.Windows.Forms.Panel();
            this.btnSelectAllDiagPriority = new System.Windows.Forms.Button();
            this.btnDeselectAllDiagPriority = new System.Windows.Forms.Button();
            this.lstDiagPriority = new System.Windows.Forms.CheckedListBox();
            this.lblDiagPriority = new System.Windows.Forms.Label();
            this.btnDiagClear = new System.Windows.Forms.Button();
            this.btnDiagSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.grpDiagPTL = new System.Windows.Forms.GroupBox();
            this.lvDiagPTL = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader10 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader7 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader9 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader6 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader8 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader11 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.pageComponentOrders = new System.Windows.Forms.TabPage();
            this.grpComponentOrders = new System.Windows.Forms.GroupBox();
            this.pnlCompSearch = new System.Windows.Forms.Panel();
            this.txtCompCPRS = new System.Windows.Forms.TextBox();
            this.lblCompCPRS = new System.Windows.Forms.Label();
            this.picCompScan = new System.Windows.Forms.PictureBox();
            this.txtCompPatient = new System.Windows.Forms.TextBox();
            this.lblCompPatient = new System.Windows.Forms.Label();
            this.txtCompSpecimen = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
            this.lblCompSpecimen = new System.Windows.Forms.Label();
            this.pnlCompOrder = new System.Windows.Forms.Panel();
            this.btnSelectAllCompOrders = new System.Windows.Forms.Button();
            this.btnDeselectAllCompOrders = new System.Windows.Forms.Button();
            this.lstCompOrder = new System.Windows.Forms.CheckedListBox();
            this.lblCompOrder = new System.Windows.Forms.Label();
            this.pnlCompTask = new System.Windows.Forms.Panel();
            this.btnSelectAllCompTaskStatus = new System.Windows.Forms.Button();
            this.btnDeselectAllCompTaskStatus = new System.Windows.Forms.Button();
            this.lstCompTaskStatus = new System.Windows.Forms.CheckedListBox();
            this.lblCompTaskStatus = new System.Windows.Forms.Label();
            this.pnlCompPriority = new System.Windows.Forms.Panel();
            this.btnSelectAllCompPriority = new System.Windows.Forms.Button();
            this.btnDeselectAllCompPriority = new System.Windows.Forms.Button();
            this.lstCompPriority = new System.Windows.Forms.CheckedListBox();
            this.lblCompPriority = new System.Windows.Forms.Label();
            this.btnCompClear = new System.Windows.Forms.Button();
            this.btnCompSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.grpComponentPTL = new System.Windows.Forms.GroupBox();
            this.lvComponentPTL = new System.Windows.Forms.ListView();
            this.columnHeader12 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader22 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader14 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader15 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader16 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader13 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader17 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader18 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader21 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader25 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.btnCancelOrders = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).BeginInit();
            this.tabPTL.SuspendLayout();
            this.pageDiagTests.SuspendLayout();
            this.grpDiagTests.SuspendLayout();
            this.pnlDiagSearch.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picDiagScan)).BeginInit();
            this.pnlDiagTest.SuspendLayout();
            this.pnlDiagTask.SuspendLayout();
            this.pnlDiagDates.SuspendLayout();
            this.grpDiagPTL.SuspendLayout();
            this.pageComponentOrders.SuspendLayout();
            this.grpComponentOrders.SuspendLayout();
            this.pnlCompSearch.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picCompScan)).BeginInit();
            this.pnlCompOrder.SuspendLayout();
            this.pnlCompTask.SuspendLayout();
            this.pnlCompPriority.SuspendLayout();
            this.grpComponentPTL.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(814, 30);
            this.vbecsLogo1.TabIndex = 5;
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 509);
            this.lblRequiredField.TabIndex = 7;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(738, 498);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.BackColor = System.Drawing.SystemColors.Control;
            this.grpImage.Controls.Add(this.picImage);
            this.grpImage.Location = new System.Drawing.Point(2, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 460);
            this.grpImage.TabIndex = 6;
            this.grpImage.TabStop = false;
            // 
            // picImage
            // 
            this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
            this.picImage.Location = new System.Drawing.Point(4, 12);
            this.picImage.Name = "picImage";
            this.picImage.Size = new System.Drawing.Size(45, 45);
            this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picImage.TabIndex = 0;
            this.picImage.TabStop = false;
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(658, 498);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 1;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(56, 498);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(84, 23);
            this.btnPrint.TabIndex = 3;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // tabPTL
            // 
            this.tabPTL.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.tabPTL.Controls.Add(this.pageDiagTests);
            this.tabPTL.Controls.Add(this.pageComponentOrders);
            this.tabPTL.Location = new System.Drawing.Point(56, 36);
            this.tabPTL.Name = "tabPTL";
            this.tabPTL.SelectedIndex = 0;
            this.tabPTL.Size = new System.Drawing.Size(756, 456);
            this.tabPTL.TabIndex = 0;
            // 
            // pageDiagTests
            // 
            this.pageDiagTests.Controls.Add(this.grpDiagTests);
            this.pageDiagTests.Controls.Add(this.grpDiagPTL);
            this.pageDiagTests.Location = new System.Drawing.Point(4, 23);
            this.pageDiagTests.Name = "pageDiagTests";
            this.pageDiagTests.Size = new System.Drawing.Size(748, 429);
            this.pageDiagTests.TabIndex = 0;
            this.pageDiagTests.Text = "Diagnostic Tests";
            // 
            // grpDiagTests
            // 
            this.grpDiagTests.AccessibleDescription = "Pending Task List Search Parameters";
            this.grpDiagTests.AccessibleName = "Pending Task List Search Parameters";
            this.grpDiagTests.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpDiagTests.Controls.Add(this.pnlDiagSearch);
            this.grpDiagTests.Controls.Add(this.pnlDiagTest);
            this.grpDiagTests.Controls.Add(this.pnlDiagTask);
            this.grpDiagTests.Controls.Add(this.pnlDiagDates);
            this.grpDiagTests.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpDiagTests.Location = new System.Drawing.Point(4, 4);
            this.grpDiagTests.Name = "grpDiagTests";
            this.grpDiagTests.Size = new System.Drawing.Size(740, 132);
            this.grpDiagTests.TabIndex = 0;
            this.grpDiagTests.TabStop = false;
            this.grpDiagTests.Text = "Pending Task List Search Parameters";
            // 
            // pnlDiagSearch
            // 
            this.pnlDiagSearch.Controls.Add(this.txtDiagCPRS);
            this.pnlDiagSearch.Controls.Add(this.lblDiagCPRS);
            this.pnlDiagSearch.Controls.Add(this.picDiagScan);
            this.pnlDiagSearch.Controls.Add(this.txtDiagPatient);
            this.pnlDiagSearch.Controls.Add(this.lblDiagPatient);
            this.pnlDiagSearch.Controls.Add(this.txtDiagSpecimen);
            this.pnlDiagSearch.Controls.Add(this.lblDiagSpecimen);
            this.pnlDiagSearch.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pnlDiagSearch.Location = new System.Drawing.Point(3, 16);
            this.pnlDiagSearch.Name = "pnlDiagSearch";
            this.pnlDiagSearch.Size = new System.Drawing.Size(186, 113);
            this.pnlDiagSearch.TabIndex = 0;
            // 
            // txtDiagCPRS
            // 
            this.txtDiagCPRS.AccessibleDescription = "C P R S order I D";
            this.txtDiagCPRS.AccessibleName = "C P R S order I D";
            this.txtDiagCPRS.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtDiagCPRS.Location = new System.Drawing.Point(20, 88);
            this.txtDiagCPRS.MaxLength = 20;
            this.txtDiagCPRS.Name = "txtDiagCPRS";
            this.txtDiagCPRS.Size = new System.Drawing.Size(161, 20);
            this.txtDiagCPRS.TabIndex = 5;
            // 
            // lblDiagCPRS
            // 
            this.lblDiagCPRS.Location = new System.Drawing.Point(20, 72);
            this.lblDiagCPRS.Name = "lblDiagCPRS";
            this.lblDiagCPRS.Size = new System.Drawing.Size(96, 16);
            this.lblDiagCPRS.TabIndex = 4;
            this.lblDiagCPRS.Text = "CPRS Order ID";
            this.lblDiagCPRS.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // picDiagScan
            // 
            this.picDiagScan.Image = ((System.Drawing.Image)(resources.GetObject("picDiagScan.Image")));
            this.picDiagScan.Location = new System.Drawing.Point(0, 16);
            this.picDiagScan.Name = "picDiagScan";
            this.picDiagScan.Size = new System.Drawing.Size(20, 20);
            this.picDiagScan.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picDiagScan.TabIndex = 34;
            this.picDiagScan.TabStop = false;
            // 
            // txtDiagPatient
            // 
            this.txtDiagPatient.AccessibleDescription = "Patient";
            this.txtDiagPatient.AccessibleName = "Patient";
            this.txtDiagPatient.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtDiagPatient.Location = new System.Drawing.Point(20, 52);
            this.txtDiagPatient.MaxLength = 30;
            this.txtDiagPatient.Name = "txtDiagPatient";
            this.txtDiagPatient.Size = new System.Drawing.Size(161, 20);
            this.txtDiagPatient.TabIndex = 3;
            // 
            // lblDiagPatient
            // 
            this.lblDiagPatient.Location = new System.Drawing.Point(20, 36);
            this.lblDiagPatient.Name = "lblDiagPatient";
            this.lblDiagPatient.Size = new System.Drawing.Size(96, 16);
            this.lblDiagPatient.TabIndex = 2;
            this.lblDiagPatient.Text = "Patient";
            this.lblDiagPatient.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtDiagSpecimen
            // 
            this.txtDiagSpecimen.AccessibleDescription = "specimen U I D";
            this.txtDiagSpecimen.AccessibleName = "specimen U I D";
            this.txtDiagSpecimen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtDiagSpecimen.Barcode = false;
            this.txtDiagSpecimen.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
            this.txtDiagSpecimen.Location = new System.Drawing.Point(20, 16);
            this.txtDiagSpecimen.MaxLength = 20;
            this.txtDiagSpecimen.Name = "txtDiagSpecimen";
            this.txtDiagSpecimen.Size = new System.Drawing.Size(161, 20);
            this.txtDiagSpecimen.TabIndex = 1;
            // 
            // lblDiagSpecimen
            // 
            this.lblDiagSpecimen.Location = new System.Drawing.Point(20, 0);
            this.lblDiagSpecimen.Name = "lblDiagSpecimen";
            this.lblDiagSpecimen.Size = new System.Drawing.Size(104, 16);
            this.lblDiagSpecimen.TabIndex = 0;
            this.lblDiagSpecimen.Text = "Specimen UID";
            this.lblDiagSpecimen.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pnlDiagTest
            // 
            this.pnlDiagTest.Controls.Add(this.btnSelectAllDiagTests);
            this.pnlDiagTest.Controls.Add(this.btnDeselectAllDiagTests);
            this.pnlDiagTest.Controls.Add(this.lstDiagTest);
            this.pnlDiagTest.Controls.Add(this.lblDiagTest);
            this.pnlDiagTest.Dock = System.Windows.Forms.DockStyle.Right;
            this.pnlDiagTest.Location = new System.Drawing.Point(189, 16);
            this.pnlDiagTest.Name = "pnlDiagTest";
            this.pnlDiagTest.Size = new System.Drawing.Size(178, 113);
            this.pnlDiagTest.TabIndex = 1;
            // 
            // btnSelectAllDiagTests
            // 
            this.btnSelectAllDiagTests.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSelectAllDiagTests.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnSelectAllDiagTests.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllDiagTests.Image")));
            this.btnSelectAllDiagTests.Location = new System.Drawing.Point(158, 0);
            this.btnSelectAllDiagTests.Name = "btnSelectAllDiagTests";
            this.btnSelectAllDiagTests.Size = new System.Drawing.Size(16, 16);
            this.btnSelectAllDiagTests.TabIndex = 3;
            this.btnSelectAllDiagTests.Click += new System.EventHandler(this.btnSelectAllDiagTests_Click);
            // 
            // btnDeselectAllDiagTests
            // 
            this.btnDeselectAllDiagTests.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDeselectAllDiagTests.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnDeselectAllDiagTests.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllDiagTests.Image")));
            this.btnDeselectAllDiagTests.Location = new System.Drawing.Point(142, 0);
            this.btnDeselectAllDiagTests.Name = "btnDeselectAllDiagTests";
            this.btnDeselectAllDiagTests.Size = new System.Drawing.Size(16, 16);
            this.btnDeselectAllDiagTests.TabIndex = 2;
            this.btnDeselectAllDiagTests.Click += new System.EventHandler(this.btnDeselectAllDiagTests_Click);
            // 
            // lstDiagTest
            // 
            this.lstDiagTest.AccessibleDescription = "Diagnostic tests";
            this.lstDiagTest.AccessibleName = "Diagnostic tests";
            this.lstDiagTest.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lstDiagTest.CheckOnClick = true;
            this.lstDiagTest.Location = new System.Drawing.Point(3, 16);
            this.lstDiagTest.Name = "lstDiagTest";
            this.lstDiagTest.Size = new System.Drawing.Size(173, 94);
            this.lstDiagTest.TabIndex = 1;
            // 
            // lblDiagTest
            // 
            this.lblDiagTest.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblDiagTest.Location = new System.Drawing.Point(4, 0);
            this.lblDiagTest.Name = "lblDiagTest";
            this.lblDiagTest.Size = new System.Drawing.Size(170, 16);
            this.lblDiagTest.TabIndex = 0;
            this.lblDiagTest.Text = "Diagnostic Tests";
            this.lblDiagTest.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pnlDiagTask
            // 
            this.pnlDiagTask.Controls.Add(this.btnSelectAllDiagTaskStatus);
            this.pnlDiagTask.Controls.Add(this.btnDeselectAllDiagTaskStatus);
            this.pnlDiagTask.Controls.Add(this.lstDiagTaskStatus);
            this.pnlDiagTask.Controls.Add(this.lblDiagTaskStatus);
            this.pnlDiagTask.Dock = System.Windows.Forms.DockStyle.Right;
            this.pnlDiagTask.Location = new System.Drawing.Point(367, 16);
            this.pnlDiagTask.Name = "pnlDiagTask";
            this.pnlDiagTask.Size = new System.Drawing.Size(206, 113);
            this.pnlDiagTask.TabIndex = 2;
            // 
            // btnSelectAllDiagTaskStatus
            // 
            this.btnSelectAllDiagTaskStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSelectAllDiagTaskStatus.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnSelectAllDiagTaskStatus.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllDiagTaskStatus.Image")));
            this.btnSelectAllDiagTaskStatus.Location = new System.Drawing.Point(186, 0);
            this.btnSelectAllDiagTaskStatus.Name = "btnSelectAllDiagTaskStatus";
            this.btnSelectAllDiagTaskStatus.Size = new System.Drawing.Size(16, 16);
            this.btnSelectAllDiagTaskStatus.TabIndex = 3;
            this.btnSelectAllDiagTaskStatus.Click += new System.EventHandler(this.btnSelectAllDiagTaskStatus_Click);
            // 
            // btnDeselectAllDiagTaskStatus
            // 
            this.btnDeselectAllDiagTaskStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDeselectAllDiagTaskStatus.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnDeselectAllDiagTaskStatus.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllDiagTaskStatus.Image")));
            this.btnDeselectAllDiagTaskStatus.Location = new System.Drawing.Point(170, 0);
            this.btnDeselectAllDiagTaskStatus.Name = "btnDeselectAllDiagTaskStatus";
            this.btnDeselectAllDiagTaskStatus.Size = new System.Drawing.Size(16, 16);
            this.btnDeselectAllDiagTaskStatus.TabIndex = 2;
            this.btnDeselectAllDiagTaskStatus.Click += new System.EventHandler(this.btnDeselectAllDiagTaskStatus_Click);
            // 
            // lstDiagTaskStatus
            // 
            this.lstDiagTaskStatus.AccessibleDescription = "Task Status";
            this.lstDiagTaskStatus.AccessibleName = "Task Status";
            this.lstDiagTaskStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lstDiagTaskStatus.CheckOnClick = true;
            this.lstDiagTaskStatus.Items.AddRange(new object[] {
            "Not Started",
            "In Progress",
            "Partially Completed",
            "Results Corrected",
            "Instrument Results Pending Review"});
            this.lstDiagTaskStatus.Location = new System.Drawing.Point(4, 16);
            this.lstDiagTaskStatus.Name = "lstDiagTaskStatus";
            this.lstDiagTaskStatus.Size = new System.Drawing.Size(198, 94);
            this.lstDiagTaskStatus.TabIndex = 1;
            // 
            // lblDiagTaskStatus
            // 
            this.lblDiagTaskStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblDiagTaskStatus.Location = new System.Drawing.Point(4, 0);
            this.lblDiagTaskStatus.Name = "lblDiagTaskStatus";
            this.lblDiagTaskStatus.Size = new System.Drawing.Size(198, 16);
            this.lblDiagTaskStatus.TabIndex = 0;
            this.lblDiagTaskStatus.Text = "Task Status";
            this.lblDiagTaskStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pnlDiagDates
            // 
            this.pnlDiagDates.Controls.Add(this.btnSelectAllDiagPriority);
            this.pnlDiagDates.Controls.Add(this.btnDeselectAllDiagPriority);
            this.pnlDiagDates.Controls.Add(this.lstDiagPriority);
            this.pnlDiagDates.Controls.Add(this.lblDiagPriority);
            this.pnlDiagDates.Controls.Add(this.btnDiagClear);
            this.pnlDiagDates.Controls.Add(this.btnDiagSearch);
            this.pnlDiagDates.Dock = System.Windows.Forms.DockStyle.Right;
            this.pnlDiagDates.Location = new System.Drawing.Point(573, 16);
            this.pnlDiagDates.Name = "pnlDiagDates";
            this.pnlDiagDates.Size = new System.Drawing.Size(164, 113);
            this.pnlDiagDates.TabIndex = 3;
            // 
            // btnSelectAllDiagPriority
            // 
            this.btnSelectAllDiagPriority.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSelectAllDiagPriority.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnSelectAllDiagPriority.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllDiagPriority.Image")));
            this.btnSelectAllDiagPriority.Location = new System.Drawing.Point(144, 0);
            this.btnSelectAllDiagPriority.Name = "btnSelectAllDiagPriority";
            this.btnSelectAllDiagPriority.Size = new System.Drawing.Size(16, 16);
            this.btnSelectAllDiagPriority.TabIndex = 3;
            this.btnSelectAllDiagPriority.Click += new System.EventHandler(this.btnSelectAllDiagPriority_Click);
            // 
            // btnDeselectAllDiagPriority
            // 
            this.btnDeselectAllDiagPriority.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDeselectAllDiagPriority.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnDeselectAllDiagPriority.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllDiagPriority.Image")));
            this.btnDeselectAllDiagPriority.Location = new System.Drawing.Point(128, 0);
            this.btnDeselectAllDiagPriority.Name = "btnDeselectAllDiagPriority";
            this.btnDeselectAllDiagPriority.Size = new System.Drawing.Size(16, 16);
            this.btnDeselectAllDiagPriority.TabIndex = 2;
            this.btnDeselectAllDiagPriority.Click += new System.EventHandler(this.btnDeselectAllDiagPriority_Click);
            // 
            // lstDiagPriority
            // 
            this.lstDiagPriority.AccessibleDescription = "priority";
            this.lstDiagPriority.AccessibleName = "priority";
            this.lstDiagPriority.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lstDiagPriority.CheckOnClick = true;
            this.lstDiagPriority.Location = new System.Drawing.Point(4, 16);
            this.lstDiagPriority.Name = "lstDiagPriority";
            this.lstDiagPriority.Size = new System.Drawing.Size(156, 64);
            this.lstDiagPriority.TabIndex = 1;
            // 
            // lblDiagPriority
            // 
            this.lblDiagPriority.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblDiagPriority.Location = new System.Drawing.Point(4, 0);
            this.lblDiagPriority.Name = "lblDiagPriority";
            this.lblDiagPriority.Size = new System.Drawing.Size(152, 16);
            this.lblDiagPriority.TabIndex = 0;
            this.lblDiagPriority.Text = "Priority";
            this.lblDiagPriority.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnDiagClear
            // 
            this.btnDiagClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDiagClear.Location = new System.Drawing.Point(84, 88);
            this.btnDiagClear.Name = "btnDiagClear";
            this.btnDiagClear.Size = new System.Drawing.Size(75, 23);
            this.btnDiagClear.TabIndex = 5;
            this.btnDiagClear.Text = "C&lear";
            this.btnDiagClear.Click += new System.EventHandler(this.btnDiagClear_Click);
            // 
            // btnDiagSearch
            // 
            this.btnDiagSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDiagSearch.EnabledButton = false;
            this.btnDiagSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnDiagSearch.Image = null;
            this.btnDiagSearch.Location = new System.Drawing.Point(4, 88);
            this.btnDiagSearch.Name = "btnDiagSearch";
            this.btnDiagSearch.Size = new System.Drawing.Size(75, 23);
            this.btnDiagSearch.TabIndex = 4;
            this.btnDiagSearch.Click += new System.EventHandler(this.btnDiagSearch_Click);
            // 
            // grpDiagPTL
            // 
            this.grpDiagPTL.AccessibleDescription = "pending task list";
            this.grpDiagPTL.AccessibleName = "pending task list";
            this.grpDiagPTL.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpDiagPTL.Controls.Add(this.lvDiagPTL);
            this.grpDiagPTL.Location = new System.Drawing.Point(4, 136);
            this.grpDiagPTL.Name = "grpDiagPTL";
            this.grpDiagPTL.Size = new System.Drawing.Size(740, 288);
            this.grpDiagPTL.TabIndex = 1;
            this.grpDiagPTL.TabStop = false;
            this.grpDiagPTL.Text = "Pending Task List";
            // 
            // lvDiagPTL
            // 
            this.lvDiagPTL.AccessibleDescription = "pending task list";
            this.lvDiagPTL.AccessibleName = "pending task list";
            this.lvDiagPTL.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvDiagPTL.CheckBoxes = true;
            this.lvDiagPTL.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader10,
            this.columnHeader3,
            this.columnHeader4,
            this.columnHeader5,
            this.columnHeader7,
            this.columnHeader9,
            this.columnHeader6,
            this.columnHeader8,
            this.columnHeader11});
            this.lvDiagPTL.FullRowSelect = true;
            this.lvDiagPTL.HideSelection = false;
            this.lvDiagPTL.Location = new System.Drawing.Point(8, 16);
            this.lvDiagPTL.MultiSelect = false;
            this.lvDiagPTL.Name = "lvDiagPTL";
            this.lvDiagPTL.Size = new System.Drawing.Size(724, 264);
            this.lvDiagPTL.TabIndex = 0;
            this.lvDiagPTL.UseCompatibleStateImageBehavior = false;
            this.lvDiagPTL.View = System.Windows.Forms.View.Details;
            this.lvDiagPTL.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvDiagPTL_ColumnClick);
            this.lvDiagPTL.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvDiagPTL_ItemCheck);
            this.lvDiagPTL.SelectedIndexChanged += new System.EventHandler(this.lvDiagPTL_SelectedIndexChanged);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "";
            this.columnHeader1.Width = 20;
            // 
            // columnHeader10
            // 
            this.columnHeader10.Text = "Priority";
            this.columnHeader10.Width = 50;
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Patient Name";
            this.columnHeader3.Width = 80;
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "Patient ID";
            this.columnHeader4.Width = 70;
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Specimen UID";
            this.columnHeader5.Width = 80;
            // 
            // columnHeader7
            // 
            this.columnHeader7.Text = "CPRS Order ID";
            this.columnHeader7.Width = 85;
            // 
            // columnHeader9
            // 
            this.columnHeader9.Text = "Diagnostic Test";
            this.columnHeader9.Width = 100;
            // 
            // columnHeader6
            // 
            this.columnHeader6.Text = "Order Comments";
            this.columnHeader6.Width = 95;
            // 
            // columnHeader8
            // 
            this.columnHeader8.Text = "Date Wanted";
            this.columnHeader8.Width = 80;
            // 
            // columnHeader11
            // 
            this.columnHeader11.Text = "Task Status";
            this.columnHeader11.Width = 70;
            // 
            // pageComponentOrders
            // 
            this.pageComponentOrders.Controls.Add(this.grpComponentOrders);
            this.pageComponentOrders.Controls.Add(this.grpComponentPTL);
            this.pageComponentOrders.Location = new System.Drawing.Point(4, 23);
            this.pageComponentOrders.Name = "pageComponentOrders";
            this.pageComponentOrders.Size = new System.Drawing.Size(748, 429);
            this.pageComponentOrders.TabIndex = 1;
            this.pageComponentOrders.Text = "Component Orders";
            this.pageComponentOrders.Visible = false;
            // 
            // grpComponentOrders
            // 
            this.grpComponentOrders.AccessibleDescription = "pending task list search parameters";
            this.grpComponentOrders.AccessibleName = "pending task list search parameters";
            this.grpComponentOrders.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpComponentOrders.Controls.Add(this.pnlCompSearch);
            this.grpComponentOrders.Controls.Add(this.pnlCompOrder);
            this.grpComponentOrders.Controls.Add(this.pnlCompTask);
            this.grpComponentOrders.Controls.Add(this.pnlCompPriority);
            this.grpComponentOrders.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpComponentOrders.Location = new System.Drawing.Point(4, 4);
            this.grpComponentOrders.Name = "grpComponentOrders";
            this.grpComponentOrders.Size = new System.Drawing.Size(740, 132);
            this.grpComponentOrders.TabIndex = 0;
            this.grpComponentOrders.TabStop = false;
            this.grpComponentOrders.Text = "Pending Task List Search Parameters";
            // 
            // pnlCompSearch
            // 
            this.pnlCompSearch.Controls.Add(this.txtCompCPRS);
            this.pnlCompSearch.Controls.Add(this.lblCompCPRS);
            this.pnlCompSearch.Controls.Add(this.picCompScan);
            this.pnlCompSearch.Controls.Add(this.txtCompPatient);
            this.pnlCompSearch.Controls.Add(this.lblCompPatient);
            this.pnlCompSearch.Controls.Add(this.txtCompSpecimen);
            this.pnlCompSearch.Controls.Add(this.lblCompSpecimen);
            this.pnlCompSearch.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pnlCompSearch.Location = new System.Drawing.Point(3, 16);
            this.pnlCompSearch.Name = "pnlCompSearch";
            this.pnlCompSearch.Size = new System.Drawing.Size(234, 113);
            this.pnlCompSearch.TabIndex = 0;
            // 
            // txtCompCPRS
            // 
            this.txtCompCPRS.AccessibleDescription = "C P R S Order I D";
            this.txtCompCPRS.AccessibleName = "C P R S Order I D";
            this.txtCompCPRS.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtCompCPRS.Location = new System.Drawing.Point(20, 88);
            this.txtCompCPRS.MaxLength = 20;
            this.txtCompCPRS.Name = "txtCompCPRS";
            this.txtCompCPRS.Size = new System.Drawing.Size(209, 20);
            this.txtCompCPRS.TabIndex = 5;
            // 
            // lblCompCPRS
            // 
            this.lblCompCPRS.Location = new System.Drawing.Point(20, 72);
            this.lblCompCPRS.Name = "lblCompCPRS";
            this.lblCompCPRS.Size = new System.Drawing.Size(96, 16);
            this.lblCompCPRS.TabIndex = 4;
            this.lblCompCPRS.Text = "CPRS Order ID";
            this.lblCompCPRS.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // picCompScan
            // 
            this.picCompScan.Image = ((System.Drawing.Image)(resources.GetObject("picCompScan.Image")));
            this.picCompScan.Location = new System.Drawing.Point(0, 16);
            this.picCompScan.Name = "picCompScan";
            this.picCompScan.Size = new System.Drawing.Size(20, 20);
            this.picCompScan.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picCompScan.TabIndex = 34;
            this.picCompScan.TabStop = false;
            // 
            // txtCompPatient
            // 
            this.txtCompPatient.AccessibleDescription = "patient";
            this.txtCompPatient.AccessibleName = "patient";
            this.txtCompPatient.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtCompPatient.Location = new System.Drawing.Point(20, 52);
            this.txtCompPatient.MaxLength = 30;
            this.txtCompPatient.Name = "txtCompPatient";
            this.txtCompPatient.Size = new System.Drawing.Size(209, 20);
            this.txtCompPatient.TabIndex = 3;
            // 
            // lblCompPatient
            // 
            this.lblCompPatient.Location = new System.Drawing.Point(20, 36);
            this.lblCompPatient.Name = "lblCompPatient";
            this.lblCompPatient.Size = new System.Drawing.Size(96, 16);
            this.lblCompPatient.TabIndex = 2;
            this.lblCompPatient.Text = "Patient";
            this.lblCompPatient.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtCompSpecimen
            // 
            this.txtCompSpecimen.AccessibleDescription = "specimen U I D";
            this.txtCompSpecimen.AccessibleName = "specimen U I D";
            this.txtCompSpecimen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtCompSpecimen.Barcode = false;
            this.txtCompSpecimen.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
            this.txtCompSpecimen.Location = new System.Drawing.Point(20, 16);
            this.txtCompSpecimen.MaxLength = 20;
            this.txtCompSpecimen.Name = "txtCompSpecimen";
            this.txtCompSpecimen.Size = new System.Drawing.Size(209, 20);
            this.txtCompSpecimen.TabIndex = 1;
            // 
            // lblCompSpecimen
            // 
            this.lblCompSpecimen.Location = new System.Drawing.Point(20, 0);
            this.lblCompSpecimen.Name = "lblCompSpecimen";
            this.lblCompSpecimen.Size = new System.Drawing.Size(104, 16);
            this.lblCompSpecimen.TabIndex = 0;
            this.lblCompSpecimen.Text = "Specimen UID";
            this.lblCompSpecimen.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pnlCompOrder
            // 
            this.pnlCompOrder.Controls.Add(this.btnSelectAllCompOrders);
            this.pnlCompOrder.Controls.Add(this.btnDeselectAllCompOrders);
            this.pnlCompOrder.Controls.Add(this.lstCompOrder);
            this.pnlCompOrder.Controls.Add(this.lblCompOrder);
            this.pnlCompOrder.Dock = System.Windows.Forms.DockStyle.Right;
            this.pnlCompOrder.Location = new System.Drawing.Point(237, 16);
            this.pnlCompOrder.Name = "pnlCompOrder";
            this.pnlCompOrder.Size = new System.Drawing.Size(184, 113);
            this.pnlCompOrder.TabIndex = 1;
            // 
            // btnSelectAllCompOrders
            // 
            this.btnSelectAllCompOrders.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSelectAllCompOrders.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnSelectAllCompOrders.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllCompOrders.Image")));
            this.btnSelectAllCompOrders.Location = new System.Drawing.Point(164, 0);
            this.btnSelectAllCompOrders.Name = "btnSelectAllCompOrders";
            this.btnSelectAllCompOrders.Size = new System.Drawing.Size(16, 16);
            this.btnSelectAllCompOrders.TabIndex = 3;
            this.btnSelectAllCompOrders.Click += new System.EventHandler(this.btnSelectAllCompOrders_Click);
            // 
            // btnDeselectAllCompOrders
            // 
            this.btnDeselectAllCompOrders.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDeselectAllCompOrders.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnDeselectAllCompOrders.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllCompOrders.Image")));
            this.btnDeselectAllCompOrders.Location = new System.Drawing.Point(148, 0);
            this.btnDeselectAllCompOrders.Name = "btnDeselectAllCompOrders";
            this.btnDeselectAllCompOrders.Size = new System.Drawing.Size(16, 16);
            this.btnDeselectAllCompOrders.TabIndex = 2;
            this.btnDeselectAllCompOrders.Click += new System.EventHandler(this.btnDeselectAllCompOrders_Click);
            // 
            // lstCompOrder
            // 
            this.lstCompOrder.AccessibleDescription = "Component Orders";
            this.lstCompOrder.AccessibleName = "Component Orders";
            this.lstCompOrder.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lstCompOrder.CheckOnClick = true;
            this.lstCompOrder.Location = new System.Drawing.Point(4, 16);
            this.lstCompOrder.Name = "lstCompOrder";
            this.lstCompOrder.Size = new System.Drawing.Size(176, 94);
            this.lstCompOrder.TabIndex = 1;
            // 
            // lblCompOrder
            // 
            this.lblCompOrder.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblCompOrder.Location = new System.Drawing.Point(4, 0);
            this.lblCompOrder.Name = "lblCompOrder";
            this.lblCompOrder.Size = new System.Drawing.Size(176, 16);
            this.lblCompOrder.TabIndex = 0;
            this.lblCompOrder.Text = "Component Orders";
            this.lblCompOrder.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pnlCompTask
            // 
            this.pnlCompTask.Controls.Add(this.btnSelectAllCompTaskStatus);
            this.pnlCompTask.Controls.Add(this.btnDeselectAllCompTaskStatus);
            this.pnlCompTask.Controls.Add(this.lstCompTaskStatus);
            this.pnlCompTask.Controls.Add(this.lblCompTaskStatus);
            this.pnlCompTask.Dock = System.Windows.Forms.DockStyle.Right;
            this.pnlCompTask.Location = new System.Drawing.Point(421, 16);
            this.pnlCompTask.Name = "pnlCompTask";
            this.pnlCompTask.Size = new System.Drawing.Size(152, 113);
            this.pnlCompTask.TabIndex = 2;
            // 
            // btnSelectAllCompTaskStatus
            // 
            this.btnSelectAllCompTaskStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSelectAllCompTaskStatus.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnSelectAllCompTaskStatus.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllCompTaskStatus.Image")));
            this.btnSelectAllCompTaskStatus.Location = new System.Drawing.Point(132, 0);
            this.btnSelectAllCompTaskStatus.Name = "btnSelectAllCompTaskStatus";
            this.btnSelectAllCompTaskStatus.Size = new System.Drawing.Size(16, 16);
            this.btnSelectAllCompTaskStatus.TabIndex = 3;
            this.btnSelectAllCompTaskStatus.Click += new System.EventHandler(this.btnSelectAllCompTaskStatus_Click);
            // 
            // btnDeselectAllCompTaskStatus
            // 
            this.btnDeselectAllCompTaskStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDeselectAllCompTaskStatus.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnDeselectAllCompTaskStatus.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllCompTaskStatus.Image")));
            this.btnDeselectAllCompTaskStatus.Location = new System.Drawing.Point(116, 0);
            this.btnDeselectAllCompTaskStatus.Name = "btnDeselectAllCompTaskStatus";
            this.btnDeselectAllCompTaskStatus.Size = new System.Drawing.Size(16, 16);
            this.btnDeselectAllCompTaskStatus.TabIndex = 2;
            this.btnDeselectAllCompTaskStatus.Click += new System.EventHandler(this.btnDeselectAllCompTaskStatus_Click);
            // 
            // lstCompTaskStatus
            // 
            this.lstCompTaskStatus.AccessibleDescription = "Task Status";
            this.lstCompTaskStatus.AccessibleName = "Task Status";
            this.lstCompTaskStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lstCompTaskStatus.CheckOnClick = true;
            this.lstCompTaskStatus.Items.AddRange(new object[] {
            "Not Started",
            "Partially Completed",
            "Filled"});
            this.lstCompTaskStatus.Location = new System.Drawing.Point(4, 16);
            this.lstCompTaskStatus.Name = "lstCompTaskStatus";
            this.lstCompTaskStatus.Size = new System.Drawing.Size(144, 94);
            this.lstCompTaskStatus.TabIndex = 1;
            // 
            // lblCompTaskStatus
            // 
            this.lblCompTaskStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblCompTaskStatus.Location = new System.Drawing.Point(4, 0);
            this.lblCompTaskStatus.Name = "lblCompTaskStatus";
            this.lblCompTaskStatus.Size = new System.Drawing.Size(144, 16);
            this.lblCompTaskStatus.TabIndex = 0;
            this.lblCompTaskStatus.Text = "Task Status";
            this.lblCompTaskStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pnlCompPriority
            // 
            this.pnlCompPriority.Controls.Add(this.btnSelectAllCompPriority);
            this.pnlCompPriority.Controls.Add(this.btnDeselectAllCompPriority);
            this.pnlCompPriority.Controls.Add(this.lstCompPriority);
            this.pnlCompPriority.Controls.Add(this.lblCompPriority);
            this.pnlCompPriority.Controls.Add(this.btnCompClear);
            this.pnlCompPriority.Controls.Add(this.btnCompSearch);
            this.pnlCompPriority.Dock = System.Windows.Forms.DockStyle.Right;
            this.pnlCompPriority.Location = new System.Drawing.Point(573, 16);
            this.pnlCompPriority.Name = "pnlCompPriority";
            this.pnlCompPriority.Size = new System.Drawing.Size(164, 113);
            this.pnlCompPriority.TabIndex = 3;
            // 
            // btnSelectAllCompPriority
            // 
            this.btnSelectAllCompPriority.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSelectAllCompPriority.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnSelectAllCompPriority.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllCompPriority.Image")));
            this.btnSelectAllCompPriority.Location = new System.Drawing.Point(144, 0);
            this.btnSelectAllCompPriority.Name = "btnSelectAllCompPriority";
            this.btnSelectAllCompPriority.Size = new System.Drawing.Size(16, 16);
            this.btnSelectAllCompPriority.TabIndex = 3;
            this.btnSelectAllCompPriority.Click += new System.EventHandler(this.btnSelectAllCompPriority_Click);
            // 
            // btnDeselectAllCompPriority
            // 
            this.btnDeselectAllCompPriority.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDeselectAllCompPriority.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnDeselectAllCompPriority.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllCompPriority.Image")));
            this.btnDeselectAllCompPriority.Location = new System.Drawing.Point(128, 0);
            this.btnDeselectAllCompPriority.Name = "btnDeselectAllCompPriority";
            this.btnDeselectAllCompPriority.Size = new System.Drawing.Size(16, 16);
            this.btnDeselectAllCompPriority.TabIndex = 2;
            this.btnDeselectAllCompPriority.Click += new System.EventHandler(this.btnDeselectAllCompPriority_Click);
            // 
            // lstCompPriority
            // 
            this.lstCompPriority.AccessibleDescription = "Priority";
            this.lstCompPriority.AccessibleName = "Priority";
            this.lstCompPriority.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lstCompPriority.CheckOnClick = true;
            this.lstCompPriority.Location = new System.Drawing.Point(4, 16);
            this.lstCompPriority.Name = "lstCompPriority";
            this.lstCompPriority.Size = new System.Drawing.Size(156, 64);
            this.lstCompPriority.TabIndex = 1;
            // 
            // lblCompPriority
            // 
            this.lblCompPriority.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblCompPriority.Location = new System.Drawing.Point(4, 0);
            this.lblCompPriority.Name = "lblCompPriority";
            this.lblCompPriority.Size = new System.Drawing.Size(152, 16);
            this.lblCompPriority.TabIndex = 0;
            this.lblCompPriority.Text = "Priority";
            this.lblCompPriority.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnCompClear
            // 
            this.btnCompClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCompClear.Location = new System.Drawing.Point(84, 88);
            this.btnCompClear.Name = "btnCompClear";
            this.btnCompClear.Size = new System.Drawing.Size(75, 23);
            this.btnCompClear.TabIndex = 5;
            this.btnCompClear.Text = "C&lear";
            this.btnCompClear.Click += new System.EventHandler(this.btnCompClear_Click);
            // 
            // btnCompSearch
            // 
            this.btnCompSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCompSearch.EnabledButton = false;
            this.btnCompSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnCompSearch.Image = null;
            this.btnCompSearch.Location = new System.Drawing.Point(4, 88);
            this.btnCompSearch.Name = "btnCompSearch";
            this.btnCompSearch.Size = new System.Drawing.Size(75, 23);
            this.btnCompSearch.TabIndex = 4;
            this.btnCompSearch.Click += new System.EventHandler(this.btnCompSearch_Click);
            // 
            // grpComponentPTL
            // 
            this.grpComponentPTL.AccessibleDescription = "pending task list";
            this.grpComponentPTL.AccessibleName = "pending task list";
            this.grpComponentPTL.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpComponentPTL.Controls.Add(this.lvComponentPTL);
            this.grpComponentPTL.Location = new System.Drawing.Point(4, 136);
            this.grpComponentPTL.Name = "grpComponentPTL";
            this.grpComponentPTL.Size = new System.Drawing.Size(740, 288);
            this.grpComponentPTL.TabIndex = 1;
            this.grpComponentPTL.TabStop = false;
            this.grpComponentPTL.Text = "Pending Task List";
            // 
            // lvComponentPTL
            // 
            this.lvComponentPTL.AccessibleDescription = "pending task list";
            this.lvComponentPTL.AccessibleName = "pending task list";
            this.lvComponentPTL.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvComponentPTL.CheckBoxes = true;
            this.lvComponentPTL.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader12,
            this.columnHeader22,
            this.columnHeader14,
            this.columnHeader15,
            this.columnHeader16,
            this.columnHeader13,
            this.columnHeader17,
            this.columnHeader18,
            this.columnHeader2,
            this.columnHeader21,
            this.columnHeader25});
            this.lvComponentPTL.FullRowSelect = true;
            this.lvComponentPTL.HideSelection = false;
            this.lvComponentPTL.Location = new System.Drawing.Point(8, 16);
            this.lvComponentPTL.MultiSelect = false;
            this.lvComponentPTL.Name = "lvComponentPTL";
            this.lvComponentPTL.Size = new System.Drawing.Size(724, 264);
            this.lvComponentPTL.TabIndex = 0;
            this.lvComponentPTL.UseCompatibleStateImageBehavior = false;
            this.lvComponentPTL.View = System.Windows.Forms.View.Details;
            this.lvComponentPTL.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvComponentPTL_ColumnClick);
            this.lvComponentPTL.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvComponentPTL_ItemCheck);
            this.lvComponentPTL.SelectedIndexChanged += new System.EventHandler(this.lvComponentPTL_SelectedIndexChanged);
            // 
            // columnHeader12
            // 
            this.columnHeader12.Text = "";
            this.columnHeader12.Width = 20;
            // 
            // columnHeader22
            // 
            this.columnHeader22.Text = "Priority";
            this.columnHeader22.Width = 50;
            // 
            // columnHeader14
            // 
            this.columnHeader14.Text = "Patient Name";
            this.columnHeader14.Width = 80;
            // 
            // columnHeader15
            // 
            this.columnHeader15.Text = "Patient ID";
            this.columnHeader15.Width = 70;
            // 
            // columnHeader16
            // 
            this.columnHeader16.Text = "Specimen UID";
            this.columnHeader16.Width = 80;
            // 
            // columnHeader13
            // 
            this.columnHeader13.Text = "CPRS Order ID";
            this.columnHeader13.Width = 85;
            // 
            // columnHeader17
            // 
            this.columnHeader17.Text = "Component";
            this.columnHeader17.Width = 70;
            // 
            // columnHeader18
            // 
            this.columnHeader18.Text = "Qty.";
            this.columnHeader18.Width = 35;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Order Comments";
            this.columnHeader2.Width = 95;
            // 
            // columnHeader21
            // 
            this.columnHeader21.Text = "Date Wanted";
            this.columnHeader21.Width = 80;
            // 
            // columnHeader25
            // 
            this.columnHeader25.Text = "Task Status";
            this.columnHeader25.Width = 70;
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // btnCancelOrders
            // 
            this.btnCancelOrders.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.btnCancelOrders.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.hlphelpChm.SetHelpKeyword(this.btnCancelOrders, "Pending_Task_List.htm");
            this.hlphelpChm.SetHelpNavigator(this.btnCancelOrders, System.Windows.Forms.HelpNavigator.Topic);
            this.btnCancelOrders.Image = ((System.Drawing.Image)(resources.GetObject("btnCancelOrders.Image")));
            this.btnCancelOrders.Location = new System.Drawing.Point(152, 498);
            this.btnCancelOrders.Name = "btnCancelOrders";
            this.hlphelpChm.SetShowHelp(this.btnCancelOrders, true);
            this.btnCancelOrders.Size = new System.Drawing.Size(128, 23);
            this.btnCancelOrders.TabIndex = 4;
            this.btnCancelOrders.Click += new System.EventHandler(this.btnCancelOrders_Click);
            // 
            // FrmPendingTaskList
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(814, 523);
            this.Controls.Add(this.btnCancelOrders);
            this.Controls.Add(this.btnPrint);
            this.Controls.Add(this.tabPTL);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnOK);
            this.hlphelpChm.SetHelpKeyword(this, "Pending_Task_List.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.Name = "FrmPendingTaskList";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Pending Task List";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmPendingTaskList_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.tabPTL, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancelOrders, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).EndInit();
            this.tabPTL.ResumeLayout(false);
            this.pageDiagTests.ResumeLayout(false);
            this.grpDiagTests.ResumeLayout(false);
            this.pnlDiagSearch.ResumeLayout(false);
            this.pnlDiagSearch.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picDiagScan)).EndInit();
            this.pnlDiagTest.ResumeLayout(false);
            this.pnlDiagTask.ResumeLayout(false);
            this.pnlDiagDates.ResumeLayout(false);
            this.grpDiagPTL.ResumeLayout(false);
            this.pageComponentOrders.ResumeLayout(false);
            this.grpComponentOrders.ResumeLayout(false);
            this.pnlCompSearch.ResumeLayout(false);
            this.pnlCompSearch.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picCompScan)).EndInit();
            this.pnlCompOrder.ResumeLayout(false);
            this.pnlCompTask.ResumeLayout(false);
            this.pnlCompPriority.ResumeLayout(false);
            this.grpComponentPTL.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Pending Task List";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.RequiredFieldsLabel = false;
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC092.SelectAtLeastOne().ResString);
			//
			this.btnDiagSearch.Text = "&Search";
			this.btnDiagSearch.EnabledButton = true;
			this.btnDiagSearch.SetToolTip(Common.StrRes.Tooltips.Common.EnterSearchCriteria().ResString);
			//
			this.btnCompSearch.Text = "&Search";
			this.btnCompSearch.EnabledButton = true;
			this.btnCompSearch.SetToolTip(Common.StrRes.Tooltips.Common.EnterSearchCriteria().ResString);
			//
			this.btnCancelOrders.Text = "Cancel &Order(s)";
			this.btnCancelOrders.EnabledButton = false;
			this.btnCancelOrders.SetToolTip(Common.StrRes.Tooltips.UC092.SelectAtLeastOneNotStarted().ResString);
			//
			this._notStartedItemsCheckedComp = 0;
			this._notStartedItemsCheckedDiag = 0;
		}

		private void PopulateTestList()
		{
			_dtTestList = BOL.OrderedTest.GetOrderableTestList();
 
			foreach(DataRow drTest in _dtTestList.Rows)
			{
				this.lstDiagTest.Items.Add(drTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim());
			}
		}

		private void PopulateTaskPriorities()
		{
			_dtPriorityList = BOL.PatientOrder.GetOrderUrgencyList();

			foreach(DataRow drPriority in _dtPriorityList.Rows)
			{
				this.lstDiagPriority.Items.Add(drPriority[Common.VbecsTables.OrderUrgency.OrderUrgencyText].ToString().Trim());
				this.lstCompPriority.Items.Add(drPriority[Common.VbecsTables.OrderUrgency.OrderUrgencyText].ToString().Trim());
			}
		}

		private void PopulateComponentClasses()
		{
			BOL.BloodComponentClass Bcc = new BOL.BloodComponentClass();
			_dtComponentClasses = Bcc.GetComponentClasses();

			foreach(DataRow drComponent in _dtComponentClasses.Rows)
			{
				this.lstCompOrder.Items.Add(drComponent[Common.VbecsTables.ComponentClass.ComponentClassShortName].ToString().Trim() + " - " + 
					drComponent[Common.VbecsTables.ComponentClass.ComponentClassName].ToString().Trim()); 
			}
		}

		/// <summary>
		/// Populate pending task list for testing tasks
		/// </summary>
		private void PopulateTestingTaskList(DataTable dtTestingTaskList)
		{
			this.lvDiagPTL.Items.Clear();
			this._notStartedItemsCheckedDiag = 0;
			if (dtTestingTaskList.Columns.Contains("ExpiredOrderComment") == false)
				dtTestingTaskList.Columns.Add("ExpiredOrderComment");

			if (dtTestingTaskList.Rows.Count == 0)
			{
				ListViewItem lvItem = new ListViewItem("No records found");
				this.lvDiagPTL.Items.Add(lvItem);
				this.lvDiagPTL.CheckBoxes = false;
				_disablePrintForTestingTask = true;
			}
			else
			{
				this.lvDiagPTL.CheckBoxes = true;

				foreach(DataRow drTestingTask in dtTestingTaskList.Rows)
				{
					ListViewItem lvItem = new ListViewItem();
					if (drTestingTask.IsNull(Common.VbecsTables.OrderUrgency.OrderUrgencyText) == false)
						lvItem.SubItems.Add(drTestingTask[Common.VbecsTables.OrderUrgency.OrderUrgencyText].ToString().Trim() + " ");
					else
						lvItem.SubItems.Add(" ");

					if (drTestingTask.IsNull(Common.VbecsTables.Patient.PatientLastName) == false 
						&& drTestingTask.IsNull(Common.VbecsTables.Patient.PatientFirstName) == false)
					{
						//CR 2667 - used BuildDispalyName method to create the name instead of building it manually
						if (drTestingTask.IsNull(Common.VbecsTables.Patient.PatientMiddleName) == false)
						{
							lvItem.SubItems.Add(BOL.Patient.BuildDisplayName(drTestingTask[Common.VbecsTables.Patient.PatientFirstName].ToString(), drTestingTask[Common.VbecsTables.Patient.PatientMiddleName].ToString(), drTestingTask[Common.VbecsTables.Patient.PatientLastName].ToString()));
						}
						else
						{
							lvItem.SubItems.Add(BOL.Patient.BuildDisplayName(drTestingTask[Common.VbecsTables.Patient.PatientFirstName].ToString(), "", drTestingTask[Common.VbecsTables.Patient.PatientLastName].ToString()));
						}
					}
					else
						lvItem.SubItems.Add(" ");
					
					if (drTestingTask.IsNull(Common.VbecsTables.Patient.DisplayVistaPatientId) == false)
						lvItem.SubItems.Add(drTestingTask[Common.VbecsTables.Patient.DisplayVistaPatientId].ToString());
					else
						lvItem.SubItems.Add(" ");

					if (drTestingTask.IsNull(Common.VbecsTables.PatientSpecimen.SpecimenUid))
						lvItem.SubItems.Add("NRQ");
					else
						lvItem.SubItems.Add(drTestingTask[Common.VbecsTables.PatientSpecimen.SpecimenUid].ToString().Trim() + " ");

					if (drTestingTask.IsNull(Common.VbecsTables.PatientOrder.OrderGroupNumber))
					{
						lvItem.SubItems.Add(" ");
					}
					else
					{
						lvItem.SubItems.Add(drTestingTask[Common.VbecsTables.PatientOrder.OrderGroupNumber].ToString());
					}

					if (drTestingTask.IsNull(Common.VbecsTables.OrderableTest.OrderableTestName) == false)
						lvItem.SubItems.Add(drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() + " ");
					else
						lvItem.SubItems.Add(" ");

					if (drTestingTask.IsNull(Common.VbecsTables.OrderedTest.OrderedTestComments) == false)
						lvItem.SubItems.Add(drTestingTask[Common.VbecsTables.OrderedTest.OrderedTestComments].ToString().Trim() + " ");
					else
						lvItem.SubItems.Add(" ");

					if (drTestingTask.IsNull(Common.VbecsTables.OrderedTest.RequiredResultsDate) == false)
						lvItem.SubItems.Add(((DateTime)drTestingTask[Common.VbecsTables.OrderedTest.RequiredResultsDate]).ToString("d").Trim() + " ");
					else
						lvItem.SubItems.Add(" ");

					if (drTestingTask.IsNull(Common.VbecsTables.TaskStatus.TaskStatusText) == false)
					{
						BOL.Lock tmpLock = BOL.LockManager.GetLock((Guid)drTestingTask[Common.VbecsTables.OrderedTest.OrderedTestGuid], false);
						if (tmpLock.LockExists)
						{
							lvItem.SubItems.Add("In Progress by " + tmpLock.UserName);
							
							drTestingTask[Common.VbecsTables.OrderedTest.TaskStatusCode] = "I";
						}
						else
						{
							if (drTestingTask[Common.VbecsTables.TaskStatus.TaskStatusCode].ToString().Trim() == Convert.ToString(Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted)))
							{
								BOL.VbecsUser LastUpdateUser = null;
								try
								{
									LastUpdateUser = new BOL.VbecsUser(drTestingTask[Common.VbecsTables.OrderedTest.LastUpdateUser].ToString() );
									if (LastUpdateUser.UserName == null)
									{
										lvItem.SubItems.Add(drTestingTask[Common.VbecsTables.TaskStatus.TaskStatusText].ToString().Trim());
									}
									else
									{
										lvItem.SubItems.Add(drTestingTask[Common.VbecsTables.TaskStatus.TaskStatusText].ToString().Trim() + " by " + LastUpdateUser.UserName);
									}
								}
								catch(BOL.BusinessObjectException)
								{
									lvItem.SubItems.Add(drTestingTask[Common.VbecsTables.TaskStatus.TaskStatusText].ToString().Trim());
								}

							}
							else
							{
								lvItem.SubItems.Add(drTestingTask[Common.VbecsTables.TaskStatus.TaskStatusText].ToString().Trim() + " ");
							}
						}
					}
					else
						lvItem.SubItems.Add(" ");

					lvItem.Tag = drTestingTask;

					this.lvDiagPTL.Items.Add(lvItem);
				}

				if (this.lvDiagPTL.Items.Count == 0)
				{
					ListViewItem lvItem = new ListViewItem("No records found");
					this.lvDiagPTL.Items.Add(lvItem);
					this.lvDiagPTL.CheckBoxes = false;
					_disablePrintForTestingTask = true;
				}
				else
				{
					_disablePrintForTestingTask = false;
				}
			}
			
			controls.VbecsFunction.SetColumnWidths(this.lvDiagPTL);
			
			if ((this._disablePrintForCompTask && this._disablePrintForTestingTask) || Common.Utility.IsDefaultPrinterConfigured == false)
			{
				this.btnPrint.Enabled = false;
			}
			else
			{
				this.btnPrint.Enabled = true;
			}
		}
 
		/// <summary>
		/// Populate pending task list for component tasks
		/// </summary>
		private void PopulateComponentTaskList(DataTable dtComponentTaskList)
		{
			this.lvComponentPTL.Items.Clear();
			this._notStartedItemsCheckedComp = 0;

			if (dtComponentTaskList.Columns.Contains("ExpiredOrderComment") == false)
				dtComponentTaskList.Columns.Add("ExpiredOrderComment");

			if (dtComponentTaskList.Rows.Count == 0)
			{
				ListViewItem lvItem = new ListViewItem("No records found");
				this.lvComponentPTL.Items.Add(lvItem);
				this.lvComponentPTL.CheckBoxes = false;
				_disablePrintForCompTask = true;
			}
			else
			{
				this.lvComponentPTL.CheckBoxes = true;

				foreach(DataRow drComponentTask in dtComponentTaskList.Rows)
				{
					ListViewItem lvItem = new ListViewItem();

					if (drComponentTask.IsNull(Common.VbecsTables.OrderUrgency.OrderUrgencyText) == false)
						lvItem.SubItems.Add(drComponentTask[Common.VbecsTables.OrderUrgency.OrderUrgencyText].ToString().Trim() + " ");
					else
						lvItem.SubItems.Add(" ");

					if (drComponentTask.IsNull(Common.VbecsTables.Patient.PatientLastName) == false && drComponentTask.IsNull(Common.VbecsTables.Patient.PatientFirstName) == false)
					{
						//CR 2667 - used BuildDispalyName method to create the name instead of building it manually
						if (drComponentTask.IsNull(Common.VbecsTables.Patient.PatientMiddleName) == false)
						{
							lvItem.SubItems.Add(BOL.Patient.BuildDisplayName(drComponentTask[Common.VbecsTables.Patient.PatientFirstName].ToString(), drComponentTask[Common.VbecsTables.Patient.PatientMiddleName].ToString(), drComponentTask[Common.VbecsTables.Patient.PatientLastName].ToString()));
						}
						else
						{
							lvItem.SubItems.Add(BOL.Patient.BuildDisplayName(drComponentTask[Common.VbecsTables.Patient.PatientFirstName].ToString(), "", drComponentTask[Common.VbecsTables.Patient.PatientLastName].ToString()));
						}
					}
					else
						lvItem.SubItems.Add(" ");

					if (drComponentTask.IsNull(Common.VbecsTables.Patient.DisplayVistaPatientId) == false)
						lvItem.SubItems.Add(drComponentTask[Common.VbecsTables.Patient.DisplayVistaPatientId].ToString());
					else
						lvItem.SubItems.Add(" ");

					if (drComponentTask.IsNull(Common.VbecsTables.PatientSpecimen.SpecimenUid) == false)
						lvItem.SubItems.Add(drComponentTask[Common.VbecsTables.PatientSpecimen.SpecimenUid].ToString().Trim() + " ");
					else
						lvItem.SubItems.Add(" ");

					if (drComponentTask.IsNull(Common.VbecsTables.PatientOrder.OrderGroupNumber))
					{
						lvItem.SubItems.Add(" ");
					}
					else
					{
						lvItem.SubItems.Add(drComponentTask[Common.VbecsTables.PatientOrder.OrderGroupNumber].ToString());
					}

					if (drComponentTask.IsNull(Common.VbecsTables.ComponentClass.ComponentClassShortName) == false)
						lvItem.SubItems.Add(drComponentTask[Common.VbecsTables.ComponentClass.ComponentClassShortName].ToString().Trim());
					else
						lvItem.SubItems.Add(" ");

					if (drComponentTask.IsNull(Common.VbecsTables.OrderedComponent.RequiredUnitQuantity) == false)
						lvItem.SubItems.Add(drComponentTask[Common.VbecsTables.OrderedComponent.RequiredUnitQuantity].ToString().Trim() + " ");
					else
						lvItem.SubItems.Add(" ");

					if (drComponentTask.IsNull(Common.VbecsTables.OrderedComponent.OrderedComponentComments) == false)
						lvItem.SubItems.Add(drComponentTask[Common.VbecsTables.OrderedComponent.OrderedComponentComments].ToString().Trim() + " ");
					else
						lvItem.SubItems.Add(" ");

					if (drComponentTask.IsNull(Common.VbecsTables.OrderedComponent.RequiredDatetime) == false)
						lvItem.SubItems.Add(((DateTime)drComponentTask[Common.VbecsTables.OrderedComponent.RequiredDatetime]).ToString("d").Trim() + " ");
					else
						lvItem.SubItems.Add(" ");

					switch(BOL.OrderedComponent.GetStatus((Guid)drComponentTask[Common.VbecsTables.OrderedComponent.OrderedComponentGuid]))
					{
						case Common.TaskStatus.NotStarted:
							lvItem.SubItems.Add(Common.Utility.ParseStringwithSpaces(Common.TaskStatus.NotStarted.ToString()));
							drComponentTask[Common.VbecsTables.OrderedComponent.TaskStatusCode] = 'N';
							drComponentTask[Common.VbecsTables.TaskStatus.TaskStatusText] = "Not Started";
							break;
						case Common.TaskStatus.PartiallyCompleted:
							lvItem.SubItems.Add(Common.Utility.ParseStringwithSpaces(Common.TaskStatus.PartiallyCompleted.ToString()));
							drComponentTask[Common.VbecsTables.OrderedComponent.TaskStatusCode] = 'P';
							drComponentTask[Common.VbecsTables.TaskStatus.TaskStatusText] = "Partially Completed";
							break;
						case Common.TaskStatus.Filled:
							lvItem.SubItems.Add(Common.Utility.ParseStringwithSpaces(Common.TaskStatus.Filled.ToString()));
							drComponentTask[Common.VbecsTables.OrderedComponent.TaskStatusCode] = 'F';
							drComponentTask[Common.VbecsTables.TaskStatus.TaskStatusText] = "Filled";
							break;
					}

					lvItem.Tag = drComponentTask;

					this.lvComponentPTL.Items.Add(lvItem);
				}

				if (this.lvComponentPTL.Items.Count == 0)
				{
					ListViewItem lvItem = new ListViewItem("No records found");
					this.lvComponentPTL.Items.Add(lvItem);
					this.lvComponentPTL.CheckBoxes = false;
					_disablePrintForCompTask = true;
				}
				else
				{
					_disablePrintForCompTask = false;
				}
			}
			
			controls.VbecsFunction.SetColumnWidths(this.lvComponentPTL);
			
			if ((this._disablePrintForCompTask && this._disablePrintForTestingTask) || Common.Utility.IsDefaultPrinterConfigured == false)
			{
				this.btnPrint.Enabled = false;
			}
			else
			{
				this.btnPrint.Enabled = true;
			}
		}

		private void SelectDeselectAll(System.Windows.Forms.CheckedListBox listBox, System.Windows.Forms.CheckState checkState)
		{
			for(int index=0; index<listBox.Items.Count; index++)
			{
				listBox.SetItemCheckState(index,checkState);
			}
		}

		private void CheckOKStatus()
		{
			int ItemsCheckedDiag = 0;
			int ItemsCheckedComp = 0;

			ItemsCheckedDiag = this.lvDiagPTL.CheckedItems.Count;
			ItemsCheckedComp = this.lvComponentPTL.CheckedItems.Count;

			if (ItemsCheckedDiag + ItemsCheckedComp == 0)
			{
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC092.SelectAtLeastOne().ResString);

				this.btnCancelOrders.EnabledButton = false;
				this.btnCancelOrders.SetToolTip(Common.StrRes.Tooltips.UC092.SelectAtLeastOne().ResString);
			}
			else if (ItemsCheckedDiag + ItemsCheckedComp > 4)
			{
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC092.TooManySelected().ResString);

				this.btnCancelOrders.EnabledButton = false;
				this.btnCancelOrders.SetToolTip(Common.StrRes.Tooltips.UC092.TooManySelected().ResString);
			}
			else
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");

				this.btnCancelOrders.EnabledButton = true;
				this.btnCancelOrders.SetToolTip("");
			}		
		}

		private void btnDiagSearch_Click(object sender, System.EventArgs e)
		{
			string TestingTaskSearchString = "";
			DataRow[] drTestingRows;

			//BR_92.08
			if (this.txtDiagCPRS.Text.Trim() != "")
			{
				this._dtAllTestingTaskList = BOL.OrderedTest.GetTestingTaskList(this.txtDiagCPRS.Text.Trim());
				this._diagSearchByOrderGroupNumber = true;
				PopulateTestingTaskList(this._dtAllTestingTaskList);
			}
			else
			{
				//going through the check lists and text fields to build a search string that
				//is going to be used to query the task tables 
				//checking priority list
				if (this._diagSearchByOrderGroupNumber == true)
				{
					this._dtAllTestingTaskList = BOL.OrderedTest.GetTestingTaskList("");
					this._diagSearchByOrderGroupNumber = false;
				}
			}
			if (this.lstDiagPriority.CheckedItems.Count > 0)
			{
				for (int i=0 ; i<this.lstDiagPriority.CheckedItems.Count ; i++)
				{
					string chkItmCode = this._dtPriorityList.Select(Common.VbecsTables.OrderUrgency.OrderUrgencyText + " = '" + 
						this.lstDiagPriority.CheckedItems[i].ToString().Trim() + 
						"'")[0][Common.VbecsTables.OrderUrgency.OrderUrgencyCode].ToString();
					if (i == 0 && this.lstDiagPriority.CheckedItems.Count == 1)
					{
						TestingTaskSearchString += Common.VbecsTables.OrderUrgency.OrderUrgencyCode + " = '" + chkItmCode + "' AND ";
					}
					else if (i == 0 && this.lstDiagPriority.CheckedItems.Count > 1)
					{
						TestingTaskSearchString += "(" + Common.VbecsTables.OrderUrgency.OrderUrgencyCode + " = '" + chkItmCode + "' OR ";
					}
					else if (i == this.lstDiagPriority.CheckedItems.Count - 1)
					{
						TestingTaskSearchString += Common.VbecsTables.OrderUrgency.OrderUrgencyCode + " = '" + chkItmCode + "') AND ";
					}
					else
					{
						TestingTaskSearchString += Common.VbecsTables.OrderUrgency.OrderUrgencyCode + " = '" + chkItmCode + "' OR ";
					}
				}
			}

			//checking test type list
			if (this.lstDiagTest.CheckedItems.Count > 0)
			{
				for (int i=0 ; i<this.lstDiagTest.CheckedItems.Count ; i++)
				{
					string chkItmCode = this._dtTestList.Select(Common.VbecsTables.OrderableTest.OrderableTestName + " = '" + 
						this.lstDiagTest.CheckedItems[i].ToString().Trim() + 
						"'")[0][Common.VbecsTables.OrderableTest.OrderableTestId].ToString();
					if (i == 0 && this.lstDiagTest.CheckedItems.Count == 1)
					{
						TestingTaskSearchString += Common.VbecsTables.OrderableTest.OrderableTestId + " = '" + chkItmCode + "' AND ";
					}
					else if (i == 0 && this.lstDiagTest.CheckedItems.Count > 1)
					{
						TestingTaskSearchString += "(" + Common.VbecsTables.OrderableTest.OrderableTestId + " = '" + chkItmCode + "' OR ";
					}
					else if (i == this.lstDiagTest.CheckedItems.Count - 1)
					{
						TestingTaskSearchString += Common.VbecsTables.OrderableTest.OrderableTestId + " = '" + chkItmCode + "') AND ";
					}
					else
					{
						TestingTaskSearchString += Common.VbecsTables.OrderableTest.OrderableTestId + " = '" + chkItmCode + "' OR ";
					}
				}
			}

			//checking task status list
			if (this.lstDiagTaskStatus.CheckedItems.Count > 0)
			{
				for (int i=0 ; i<this.lstDiagTaskStatus.CheckedItems.Count ; i++)
				{
					string chkItmCode = this._dtTaskStatusList.Select("TaskStatusText = '" + this.lstDiagTaskStatus.CheckedItems[i].ToString().Trim() + "'")[0]["TaskStatusCode"].ToString();
					if (i == 0 && this.lstDiagTaskStatus.CheckedItems.Count == 1)
					{
						TestingTaskSearchString += "TaskStatusCode = '" + chkItmCode + "' AND ";
					}
					else if (i == 0 && this.lstDiagTaskStatus.CheckedItems.Count > 1)
					{
						TestingTaskSearchString += "(TaskStatusCode = '" + chkItmCode + "' OR ";
					}
					else if (i == this.lstDiagTaskStatus.CheckedItems.Count - 1)
					{
						TestingTaskSearchString += "TaskStatusCode = '" + chkItmCode + "') AND ";
					}
					else
					{
						TestingTaskSearchString += "TaskStatusCode = '" + chkItmCode + "' OR ";
					}
				}
			}

			//checking the specimen uid text field
			if (this.txtDiagSpecimen.Text.Trim() != "")
			{
				TestingTaskSearchString += "SpecimenUid LIKE '" + this.txtDiagSpecimen.Text.Trim() + "*' AND ";
			}

			//checking the patient text field
			if (this.txtDiagPatient.Text.Trim() != "")
			{
				string patientName = "";
				string patientSSN = "";
				ParseSearchString(this.txtDiagPatient.Text.Trim(), out patientName, out patientSSN);

				if (patientName != "")
				{
					patientName += "*";
					TestingTaskSearchString += "PatientLastName LIKE '" + patientName + "' AND ";
				}

				if (patientSSN != "")
				{
					patientSSN = "*" + patientSSN;
					TestingTaskSearchString += "PatientSsn LIKE '" + patientSSN + "' AND ";
				}
			}

			if (TestingTaskSearchString.Length > 0)
			{
				//getting rid of the final "AND"
				TestingTaskSearchString = TestingTaskSearchString.Substring(0, TestingTaskSearchString.Length - 5);
				drTestingRows = this._dtAllTestingTaskList.Select(TestingTaskSearchString, "SortColumn ASC, PatientLastName ASC");
				PopulateTestingTaskList(DataRowArrayToDataTable(drTestingRows, this._dtAllTestingTaskList.Clone()));
			}
			else
			{
				PopulateTestingTaskList(this._dtAllTestingTaskList);
			}
			CheckOKStatus();
		}

		/// <summary>
		/// performes conversion of datarow array into datatable
		/// </summary>
		/// <param name="drArray"></param>
		/// <param name="dtOut"></param>
		/// <returns></returns>
		private DataTable DataRowArrayToDataTable(DataRow[] drArray, DataTable dtOut)
		{
			foreach(DataRow drItem in drArray)
			{
				dtOut.Rows.Add(drItem.ItemArray);
			}

			return dtOut;
		}

		private void ParseSearchString(string searchString, out string patientName, out string patientSSN)
		{
			Regex _lastfiveEx = Common.RegularExpressions.PatientInitialAndLastFourSSN();
			Regex _ssnEx = Common.RegularExpressions.PatientSsn();
			Regex _nameEx = Common.RegularExpressions.PatientName();

			//Need to parse search string to determine if search is intended
			//to be on Name, full SSN, Last 4 or initial and Last 4.
			searchString = searchString.ToUpper();
			patientName = string.Empty;
			patientSSN = string.Empty;
			//
			//Check for Last 5
			if (_lastfiveEx.IsMatch(searchString))
			{
				patientName = searchString.Substring(0,1);
				patientSSN = searchString.Substring(1,4);
				return;
			}
			//Check for SSN (full or last 4)
			if (_ssnEx.IsMatch(searchString))
			{
				patientSSN = searchString;
				return;
			}
			//Check for Name
			if (_nameEx.IsMatch(searchString))
			{
				patientName = searchString;
				return;
			}
		}

		private void btnDiagClear_Click(object sender, System.EventArgs e)
		{
			foreach (int chkItm in this.lstDiagPriority.CheckedIndices)
			{
				this.lstDiagPriority.SetItemCheckState(chkItm, System.Windows.Forms.CheckState.Unchecked);
			}

			foreach (int chkItm in this.lstDiagTaskStatus.CheckedIndices)
			{
				this.lstDiagTaskStatus.SetItemCheckState(chkItm, System.Windows.Forms.CheckState.Unchecked);
			}

			foreach (int chkItm in this.lstDiagTest.CheckedIndices)
			{
				this.lstDiagTest.SetItemCheckState(chkItm, System.Windows.Forms.CheckState.Unchecked);
			}

			this.txtDiagPatient.Text = "";
			this.txtDiagSpecimen.Text = "";
			this.txtDiagCPRS.Text = "";
		}

		private void btnCompSearch_Click(object sender, System.EventArgs e)
		{
			string ComponentTaskSearchString = "";
			DataRow[] drComponentRows;

			//BR_92.08
			if (this.txtCompCPRS.Text.Trim() != "")
			{
				this._dtAllComponentTaskList = BOL.OrderedComponent.GetComponentTaskList(this.txtCompCPRS.Text.Trim());
				PopulateComponentTaskList(this._dtAllComponentTaskList);
				this._compSearchByOrderGroupNumber = true;
			}
			else
			{
				//going through the check lists and text fields to build a search string that
				//is going to be used to query the task tables 
				//checking priority list
				if (this._compSearchByOrderGroupNumber == true)
				{
					this._dtAllComponentTaskList = BOL.OrderedComponent.GetComponentTaskList("");
					foreach (DataRow drComponentTask in this._dtAllComponentTaskList.Rows)
					{
						switch(BOL.OrderedComponent.GetStatus((Guid)drComponentTask[Common.VbecsTables.OrderedComponent.OrderedComponentGuid]))
						{
							case Common.TaskStatus.NotStarted:
								drComponentTask[Common.VbecsTables.OrderedComponent.TaskStatusCode] = 'N';
								drComponentTask[Common.VbecsTables.TaskStatus.TaskStatusText] = "Not Started";
								break;
							case Common.TaskStatus.PartiallyCompleted:
								drComponentTask[Common.VbecsTables.OrderedComponent.TaskStatusCode] = 'P';
								drComponentTask[Common.VbecsTables.TaskStatus.TaskStatusText] = "Partially Completed";
								break;
							case Common.TaskStatus.Filled:
								drComponentTask[Common.VbecsTables.OrderedComponent.TaskStatusCode] = 'F';
								drComponentTask[Common.VbecsTables.TaskStatus.TaskStatusText] = "Filled";
								break;
						}
					}

					this._compSearchByOrderGroupNumber = false;
				}
			}

			if (this.lstCompPriority.CheckedItems.Count > 0)
			{
				for (int i=0 ; i<this.lstCompPriority.CheckedItems.Count ; i++)
				{
					string chkItmCode = this._dtPriorityList.Select("OrderUrgencyText = '" + this.lstCompPriority.CheckedItems[i].ToString().Trim() + "'")[0]["OrderUrgencyCode"].ToString();
					if (i == 0 && this.lstCompPriority.CheckedItems.Count == 1)
					{
						ComponentTaskSearchString += "OrderUrgencyCode = '" + chkItmCode + "' AND ";
					}
					else if (i == 0 && this.lstCompPriority.CheckedItems.Count > 1)
					{
						ComponentTaskSearchString += "(OrderUrgencyCode = '" + chkItmCode + "' OR ";
					}
					else if (i == this.lstCompPriority.CheckedItems.Count - 1)
					{
						ComponentTaskSearchString += "OrderUrgencyCode = '" + chkItmCode + "') AND ";
					}
					else
					{
						ComponentTaskSearchString += "OrderUrgencyCode = '" + chkItmCode + "' OR ";
					}
				}
			}

			//checking component type list
			if (this.lstCompOrder.CheckedItems.Count > 0)
			{
				for (int i=0 ; i<this.lstCompOrder.CheckedItems.Count ; i++)
				{
					string chkItmCode = this._dtComponentClasses.Select("ComponentClassShortName LIKE '" + this.lstCompOrder.CheckedItems[i].ToString().Trim().Substring(0, 2) + "*'")[0]["ComponentClassShortName"].ToString();
					if (i == 0 && this.lstCompOrder.CheckedItems.Count == 1)
					{
						ComponentTaskSearchString += "ComponentClassShortName = '" + chkItmCode + "' AND ";
					}
					else if (i == 0 && this.lstCompOrder.CheckedItems.Count > 1)
					{
						ComponentTaskSearchString += "(ComponentClassShortName = '" + chkItmCode + "' OR ";
					}
					else if (i == this.lstCompOrder.CheckedItems.Count - 1)
					{
						ComponentTaskSearchString += "ComponentClassShortName = '" + chkItmCode + "') AND ";
					}
					else
					{
						ComponentTaskSearchString += "ComponentClassShortName = '" + chkItmCode + "' OR ";
					}
				}
			}

			//checking task status list
			if (this.lstCompTaskStatus.CheckedItems.Count > 0)
			{
				for (int i=0 ; i<this.lstCompTaskStatus.CheckedItems.Count ; i++)
				{
					string chkItmCode = this._dtTaskStatusList.Select("TaskStatusText = '" + this.lstCompTaskStatus.CheckedItems[i].ToString().Trim() + "'")[0]["TaskStatusCode"].ToString();
					if (i == 0 && this.lstCompTaskStatus.CheckedItems.Count == 1)
					{
						ComponentTaskSearchString += "TaskStatusCode = '" + chkItmCode + "' AND ";
					}
					else if (i == 0 && this.lstCompTaskStatus.CheckedItems.Count > 1)
					{
						ComponentTaskSearchString += "(TaskStatusCode = '" + chkItmCode + "' OR ";
					}
					else if (i == this.lstCompTaskStatus.CheckedItems.Count - 1)
					{
						ComponentTaskSearchString += "TaskStatusCode = '" + chkItmCode + "') AND ";
					}
					else
					{
						ComponentTaskSearchString += "TaskStatusCode = '" + chkItmCode + "' OR ";
					}
				}
			}

			//checking the specimen uid text field
			if (this.txtCompSpecimen.Text.Trim() != "")
			{
				ComponentTaskSearchString += "SpecimenUid LIKE '" + this.txtCompSpecimen.Text.Trim() + "*' AND ";
			}

			//checking the patient text field
			if (this.txtCompPatient.Text.Trim() != "")
			{
				string patientName = "";
				string patientSSN = "";
				ParseSearchString(this.txtCompPatient.Text.Trim(), out patientName, out patientSSN);

				if (patientName != "")
				{
					patientName += "*";
					ComponentTaskSearchString += "PatientLastName LIKE '" + patientName + "' AND ";
				}

				if (patientSSN != "")
				{
					patientSSN = "*" + patientSSN;
					ComponentTaskSearchString += "PatientSsn LIKE '" + patientSSN + "' AND ";
				}
			}

			if (ComponentTaskSearchString.Length > 0)
			{
				//getting rid of the final "AND"
				ComponentTaskSearchString = ComponentTaskSearchString.Substring(0, ComponentTaskSearchString.Length - 5);
				drComponentRows = this._dtAllComponentTaskList.Select(ComponentTaskSearchString, "SortColumn ASC, PatientLastName ASC");
				PopulateComponentTaskList(DataRowArrayToDataTable(drComponentRows, this._dtAllComponentTaskList.Clone()));
			}
			else
			{
				PopulateComponentTaskList(this._dtAllComponentTaskList);
			}

			CheckOKStatus();
		}

		private void btnCompClear_Click(object sender, System.EventArgs e)
		{
			foreach (int chkItm in this.lstCompOrder.CheckedIndices)
			{
				this.lstCompOrder.SetItemCheckState(chkItm, System.Windows.Forms.CheckState.Unchecked);
			}

			foreach (int chkItm in this.lstCompPriority.CheckedIndices)
			{
				this.lstCompPriority.SetItemCheckState(chkItm, System.Windows.Forms.CheckState.Unchecked);
			}

			foreach (int chkItm in this.lstCompTaskStatus.CheckedIndices)
			{
				this.lstCompTaskStatus.SetItemCheckState(chkItm, System.Windows.Forms.CheckState.Unchecked);
			}

			this.txtCompPatient.Text = "";
			this.txtCompSpecimen.Text = "";
			this.txtCompCPRS.Text = "";
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			//Testing task list used as an input for UC_56
			ArrayList SelectedTestingTasks = new ArrayList();

			//Component task list used as an input for UC_3
			ArrayList SelectedComponentTasks = new ArrayList();

			bool hasTrw = false;
			BOL.OrderedTest lockOrderedTest;
			ArrayList expiredOrderExceptions = new ArrayList();

			foreach(ListViewItem lvItm in this.lvDiagPTL.CheckedItems)
			{
				DataRow drTestingTask = (DataRow)lvItm.Tag;
				lockOrderedTest = new BOL.OrderedTest(drTestingTask);

                //CR 3523
                DataTable refreshedOrderedTest = BOL.OrderedTest.GetOrderedTest(lockOrderedTest.OrderedTestGuid);
                if (refreshedOrderedTest.Rows.Count > 0)
                {
                    string refreshedStatus = "";
                    BOL.Lock tmpLock = BOL.LockManager.GetLock(lockOrderedTest.OrderedTestGuid, false);

                    if (tmpLock.LockExists)
                    {
                        refreshedStatus = Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.InProgress).ToString();
                    }
                    else
                    {
                        refreshedStatus = refreshedOrderedTest.Rows[0][VbecsTables.OrderedTest.TaskStatusCode].ToString().Trim().ToUpper();
                    }

                    if (refreshedStatus != lockOrderedTest.TaskStatusCode.ToString().Trim().ToUpper())
                    {
                        //we have to refresh PTL since the status of the task changed
                        GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC092.RefreshPTL());

                        _dtAllComponentTaskList = BOL.OrderedComponent.GetComponentTaskList("");
                        PopulateComponentTaskList(_dtAllComponentTaskList);

                        _dtAllTestingTaskList = BOL.OrderedTest.GetTestingTaskList("");
                        PopulateTestingTaskList(_dtAllTestingTaskList);
                        CheckOKStatus();
                        return;
                    }
                }

				if (drTestingTask.IsNull("ExpiredOrderComment") == false)
				{
					BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_task_processed, drTestingTask["ExpiredOrderComment"].ToString(), Common.LogonUser.LogonUserName);
					exRep.GenerateExceptionExpiredTask(lockOrderedTest, null, "");
					expiredOrderExceptions.Add(exRep);
				}

				hasTrw = (lockOrderedTest.OrderableTestId == (int)Common.OrderableTest.TRW);

				//UC_21 stands alone.
				if (hasTrw)
				{
					this._frmTrw = new FrmTransfusionReactionWorkup(lockOrderedTest);
					if (this._frmTrw.DialogResult != DialogResult.Abort)
					{
						this._frmTrw.MdiParent = this.MdiParent;

						this._frmTrw.Show();
						this.Close();
						return;
					}
					else
						return;
				}

				SelectedTestingTasks.Add(lockOrderedTest);

			}


			foreach(ListViewItem lvItm in this.lvComponentPTL.CheckedItems)
			{
				DataRow drComponent = (DataRow)lvItm.Tag;
				BOL.OrderedComponent OrderedComponent = new BOL.OrderedComponent(drComponent);
				
				if (drComponent.IsNull("ExpiredOrderComment") == false)
				{
					BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_task_processed, drComponent["ExpiredOrderComment"].ToString(), Common.LogonUser.LogonUserName);
					exRep.GenerateExceptionExpiredTask(null, OrderedComponent, "");
					expiredOrderExceptions.Add(exRep);
				}

				SelectedComponentTasks.Add(OrderedComponent);
			}

			//if there are component tasks call UC_3 and than UC_56
			if (SelectedComponentTasks.Count > 0)
			{
				FrmSelectUnitsForPatient frmSUFP = new FrmSelectUnitsForPatient(SelectedComponentTasks, SelectedTestingTasks, false, expiredOrderExceptions);
				if (frmSUFP.DialogResult != DialogResult.Abort)
				{
					frmSUFP.MdiParent = this.MdiParent;
					//frmSUFP.Parent = null;
					frmSUFP.Show();
					this.Close();
				}
				// Call UC56 here passing in:
				// 1) OrderedComponents that require crossmatch (ArrayList)
				// 2) SelectedTesting tasks (ArrayList)
			}
			//calling UC_56 (this code should probably be moved to UC_3)
			else if (SelectedTestingTasks.Count > 0)
			{
				DlgSelectTestingRack dlg = new DlgSelectTestingRack(SelectedTestingTasks, this.MdiParent, expiredOrderExceptions);

				if (dlg.DialogResult != DialogResult.Abort)
				{
					dlg.MdiParent = this.MdiParent;
					dlg.Show();
					this.Close();
				}
			}
		}

		private void lvDiagPTL_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			int ItemsCheckedDiag = 0;
			int ItemsCheckedComp = 0;

			ItemsCheckedComp = this.lvComponentPTL.CheckedItems.Count;
			DataRow drTestingTask = (DataRow)this.lvDiagPTL.Items[e.Index].Tag;

			if (e.NewValue == CheckState.Checked)
			{
				bool aboRhCompletedForTAS = false;
				if (drTestingTask[Common.VbecsTables.TaskStatus.TaskStatusCode].ToString().Trim() == Convert.ToString(Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted)))
				{
					DataTable dtTestResults = BOL.OrderedTest.GetTestResultsForTask((Guid)drTestingTask[Common.VbecsTables.OrderedTest.OrderedTestGuid]);
					if (dtTestResults.Select(Common.VbecsTables.BloodTestType.BloodTestTypeId + "= 65").Length > 0 && //ABO Interp
						dtTestResults.Select(Common.VbecsTables.BloodTestType.BloodTestTypeId + "= 68").Length > 0)   //RH Interp
					{
						if (dtTestResults.Select(Common.VbecsTables.BloodTestType.BloodTestTypeId + "= 65")[0][Common.VbecsTables.SpecimenTest.TestResultId].ToString().Trim() != "" &&
							dtTestResults.Select(Common.VbecsTables.BloodTestType.BloodTestTypeId + "= 68")[0][Common.VbecsTables.SpecimenTest.TestResultId].ToString().Trim() != "")
						{
							aboRhCompletedForTAS = true;
						}
					}
				}

				//BR_92.06
				if ((drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim().IndexOf("ABO/Rh")>-1) ||
					(drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "TAS" && aboRhCompletedForTAS == false))
				{
					BOL.Patient patient = new BOL.Patient((Guid)drTestingTask[Common.VbecsTables.Patient.PatientGuid]);
					DataTable dtpatientAboRhHistory = patient.GetPatientAboRHHistory();
					//CR 2576 separated ABO results from RH results to make sure that if they are saved at different times the system
					//compares ABO with ABO and RH with RH
					DataRow[] aboHistory = dtpatientAboRhHistory.Select(Common.VbecsTables.SpecimenTest.BloodTestTypeId + " = 18 OR " +
																	  Common.VbecsTables.SpecimenTest.BloodTestTypeId + " = 65 OR " +
																	  Common.VbecsTables.SpecimenTest.BloodTestTypeId + " = 118", 
																	  Common.VbecsTables.SpecimenTest.TestDate + " DESC");
					DataRow[] rhHistory = dtpatientAboRhHistory.Select(Common.VbecsTables.SpecimenTest.BloodTestTypeId + " = 21 OR " +
																		Common.VbecsTables.SpecimenTest.BloodTestTypeId + " = 68 OR " +
																		Common.VbecsTables.SpecimenTest.BloodTestTypeId + " = 121", 
																		Common.VbecsTables.SpecimenTest.TestDate + " DESC");
					if (aboHistory.Length > 0 && rhHistory.Length > 0)
					{
						//Skip if the most recent result was justified.
						if ((bool)aboHistory[0][Common.VbecsTables.SpecimenTest.AboRhChangeIndicator] == false)
						{
							if (aboHistory.Length == 1 && rhHistory.Length == 1)
							{
								string abo = aboHistory[0][Common.VbecsTables.BloodUnitTest.TestResultId].ToString().Trim();
								string rh = rhHistory[0][Common.VbecsTables.BloodUnitTest.TestResultId].ToString().Trim();
							
								if (patient.ConversionAboRH.Abo != Common.ABO.NA &&
									patient.ConversionAboRH.RH != Common.RH.NotProvided)
								{
									if (patient.ConversionAboRH.Abo != Common.Utility.GetAboFromString(abo) ||
										patient.ConversionAboRH.RH != Common.Utility.GetRhFromString(rh))
									{
										GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC092.ABORhMismatch());
										e.NewValue = CheckState.Unchecked;
										return;
									}
								}
							}
							else if (aboHistory.Length > 1 && rhHistory.Length > 1)
							{
								string aboNew = aboHistory[0][Common.VbecsTables.BloodUnitTest.TestResultId].ToString().Trim();
								string rhNew = rhHistory[0][Common.VbecsTables.BloodUnitTest.TestResultId].ToString().Trim();
								string aboOld = aboHistory[1][Common.VbecsTables.BloodUnitTest.TestResultId].ToString().Trim();
								string rhOld = rhHistory[1][Common.VbecsTables.BloodUnitTest.TestResultId].ToString().Trim();
								if (aboNew != "" &&
									rhNew != "" &&
									aboOld != "" &&
									rhOld != "")
								{
									if (aboNew != aboOld ||
										rhNew != rhOld)
									{
										GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC092.ABORhMismatch());
										e.NewValue = CheckState.Unchecked;
										return;
									}
								}
							}
						}
					}
				}

				//BR_92.10
				bool isDAT = false;
				if (ThisUser.CurrentDivisionRole.Division.PatientTestingConfiguration == Common.PatientTestingConfiguration.AntibodyDAT)
				{
					isDAT = true;
				}

				foreach(ListViewItem lvItm in this.lvDiagPTL.CheckedItems)
				{
					DataRow drTest = (DataRow)lvItm.Tag;
					//
					//A TRW has already been checked - therefore no other tasks can be checked
					if (drTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "TRW")
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC092.TRWsMustBeSelectedAlone());
						e.NewValue = CheckState.Unchecked;
						return;
					}
					//
					if (drTest[Common.VbecsTables.Patient.PatientGuid].Equals(drTestingTask[Common.VbecsTables.Patient.PatientGuid]))
					{

						if (drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Replace("Repeat", "").Trim() ==
							drTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Replace("Repeat", "").Trim())
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC092.SameTasksForPatient());
							e.NewValue = CheckState.Unchecked;
							return;
						}

						if (drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "TAS")
						{
							if (drTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "ABO/Rh" ||
								drTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "Repeat ABO/Rh" ||
								drTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "ABS" ||
								drTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "Repeat ABS" ||
								(drTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "DAT" && isDAT == true) ||
								(drTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "Repeat DAT" && isDAT == true))
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC092.SameTasksForPatient());
								e.NewValue = CheckState.Unchecked;
								return;
							}
						}

						if (drTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "TAS")
						{
							if (drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "ABO/Rh" ||
								drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "Repeat ABO/Rh" ||
								drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "ABS" ||
								drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "Repeat ABS" ||
								(drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "DAT" && isDAT == true) ||
								(drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "Repeat DAT" && isDAT == true))
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC092.SameTasksForPatient());
								e.NewValue = CheckState.Unchecked;
								return;
							}
						}
					}
				}

				ItemsCheckedDiag = this.lvDiagPTL.CheckedItems.Count + 1;

				//No BR ref - but we cannot mix TRWs with other tasks...
				if ((drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "TRW")&&((ItemsCheckedComp>0)||(ItemsCheckedDiag>1)))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC092.TRWsMustBeSelectedAlone());
					e.NewValue = CheckState.Unchecked;
					return;
				}


				//checking the status of test order
				if (Convert.ToChar(drTestingTask[Common.VbecsTables.OrderedTest.TaskStatusCode]) == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.NotStarted) ||
					Convert.ToChar(drTestingTask[Common.VbecsTables.OrderedTest.TaskStatusCode]) == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
				{
					_notStartedItemsCheckedDiag += 1;
				}
				//BR_92.09
				DateTime specimenExpiration = new DateTime();
				if (drTestingTask.IsNull(Common.VbecsTables.PatientSpecimen.SpecimenExpirationDate) == true)
				{
					specimenExpiration = ((DateTime)drTestingTask[Common.VbecsTables.PatientOrder.OrderReceivedDatetime]).AddDays(10);
				}
				else
				{
					specimenExpiration = (DateTime)drTestingTask[Common.VbecsTables.PatientSpecimen.SpecimenExpirationDate];
				}

				if (specimenExpiration < BOL.VBECSDateTime.GetDivisionCurrentDateTime())
				{
					DlgOverrideComment dlg = new DlgOverrideComment( "Expired Order Selected", Common.StrRes.ConfMsg.UC056.ExpiredTaskProcessed().ResString, "PT" );

                    dlg.ShowDialog(this);
					if( dlg.DialogResult == DialogResult.Cancel )
					{
						e.NewValue = CheckState.Unchecked;
						return;
					}
					else
					{
						drTestingTask["ExpiredOrderComment"] = dlg.Comment;
					}
				}
			}
			else if (e.NewValue == CheckState.Unchecked)
			{
				ItemsCheckedDiag = this.lvDiagPTL.CheckedItems.Count - 1;

				//checking the status of test order
				if (Convert.ToChar(drTestingTask[Common.VbecsTables.OrderedTest.TaskStatusCode]) == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.NotStarted) ||
					Convert.ToChar(drTestingTask[Common.VbecsTables.OrderedTest.TaskStatusCode]) == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
				{
					_notStartedItemsCheckedDiag -= 1;
				}
			}

			if (ItemsCheckedDiag + ItemsCheckedComp == 0)
			{
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC092.SelectAtLeastOne().ResString);
			}
			else if (ItemsCheckedDiag + ItemsCheckedComp > 4)
			{
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC092.TooManySelected().ResString);
			}
			else
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");
			}

			if (_notStartedItemsCheckedDiag + _notStartedItemsCheckedComp == 0)
			{
				this.btnCancelOrders.EnabledButton = false;
				this.btnCancelOrders.SetToolTip(Common.StrRes.Tooltips.UC092.SelectAtLeastOneNotStarted().ResString);
			}
			else if (_notStartedItemsCheckedDiag + _notStartedItemsCheckedComp > 4)
			{
				this.btnCancelOrders.EnabledButton = false;
				this.btnCancelOrders.SetToolTip(Common.StrRes.Tooltips.UC092.TooManyNotStartedSelected().ResString);
			}
			else
			{
				this.btnCancelOrders.EnabledButton = true;
				this.btnCancelOrders.SetToolTip("");
			}		

		}

		private void lvComponentPTL_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			int ItemsCheckedDiag = 0;
			int ItemsCheckedComp = 0;

			ItemsCheckedDiag = this.lvDiagPTL.CheckedItems.Count;

			foreach(ListViewItem lvItm in this.lvDiagPTL.CheckedItems)
			{
				DataRow drTest = (DataRow)lvItm.Tag;
				//A TRW has already been checked - therefore no other tasks can be checked
				if (drTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString().Trim() == "TRW")
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC092.TRWsMustBeSelectedAlone());
					e.NewValue = CheckState.Unchecked;
					return;
				}
			}
			
			if (e.NewValue == CheckState.Checked)
			{
				ItemsCheckedComp = this.lvComponentPTL.CheckedItems.Count + 1;

				//checking the status of component order
				DataRow drComponent = (DataRow)this.lvComponentPTL.Items[e.Index].Tag;
				
				int selectedUnits = BOL.OrderedUnit.GetOrderedUnitCount((Guid)drComponent[Common.VbecsTables.OrderedComponent.OrderedComponentGuid], Common.LogonUser.LogonUserDivisionCode);
				if (selectedUnits == 0) //Not Started
				{
					_notStartedItemsCheckedComp += 1;
				}

				//BR_92.09
				DateTime specimenExpiration = new DateTime();
				if (drComponent.IsNull(Common.VbecsTables.PatientSpecimen.SpecimenExpirationDate) == true)
				{
					specimenExpiration = ((DateTime)drComponent[Common.VbecsTables.PatientOrder.OrderReceivedDatetime]).AddDays(10);
				}
				else
				{
					specimenExpiration = (DateTime)drComponent[Common.VbecsTables.PatientSpecimen.SpecimenExpirationDate];
				}

				if (specimenExpiration < BOL.VBECSDateTime.GetDivisionCurrentDateTime())
				{
					DlgOverrideComment dlg = new DlgOverrideComment( "Expired Order Selected", Common.StrRes.ConfMsg.UC056.ExpiredTaskProcessed().ResString, "PT" );
					if( dlg.ShowDialog(this) == DialogResult.Cancel )
					{
						e.NewValue = CheckState.Unchecked;
						return;
					}
					else
					{
						drComponent["ExpiredOrderComment"] = dlg.Comment;
					}
				}
			}
			else if (e.NewValue == CheckState.Unchecked)
			{
				ItemsCheckedComp = this.lvComponentPTL.CheckedItems.Count - 1;

				//checking the status of component order
				DataRow drComponent = (DataRow)this.lvComponentPTL.Items[e.Index].Tag;
				int selectedUnits = BOL.OrderedUnit.GetOrderedUnitCount((Guid)drComponent[Common.VbecsTables.OrderedComponent.OrderedComponentGuid], Common.LogonUser.LogonUserDivisionCode);
				if (selectedUnits == 0) //Not Started
				{
					_notStartedItemsCheckedComp -= 1;
				}
			}

			if (ItemsCheckedDiag + ItemsCheckedComp == 0)
			{
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC092.SelectAtLeastOne().ResString);
			}
			else if (ItemsCheckedDiag + ItemsCheckedComp > 4)
			{
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC092.TooManySelected().ResString);
			}
			else
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");
			}		

			if (_notStartedItemsCheckedDiag + _notStartedItemsCheckedComp == 0)
			{
				this.btnCancelOrders.EnabledButton = false;
				this.btnCancelOrders.SetToolTip(Common.StrRes.Tooltips.UC092.SelectAtLeastOneNotStarted().ResString);
			}
			else if (_notStartedItemsCheckedDiag + _notStartedItemsCheckedComp > 4)
			{
				this.btnCancelOrders.EnabledButton = false;
				this.btnCancelOrders.SetToolTip(Common.StrRes.Tooltips.UC092.TooManyNotStartedSelected().ResString);
			}
			else
			{
				this.btnCancelOrders.EnabledButton = true;
				this.btnCancelOrders.SetToolTip("");
			}		
		}

		/// <summary>
		/// Checks the number of checked Not Started tasks that are eligible for cancellation
		/// </summary>
		private void CheckCancelOrderStatus()
		{
			if (_notStartedItemsCheckedDiag + _notStartedItemsCheckedComp == 0)
			{
				this.btnCancelOrders.EnabledButton = false;
				this.btnCancelOrders.SetToolTip(Common.StrRes.Tooltips.UC092.SelectAtLeastOneNotStarted().ResString);
			}
			else if (_notStartedItemsCheckedDiag + _notStartedItemsCheckedComp > 4)
			{
				this.btnCancelOrders.EnabledButton = false;
				this.btnCancelOrders.SetToolTip(Common.StrRes.Tooltips.UC092.TooManyNotStartedSelected().ResString);
			}
			else
			{
				this.btnCancelOrders.EnabledButton = true;
				this.btnCancelOrders.SetToolTip("");
			}		

		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
			System.Drawing.Printing.PrinterSettings settings = new System.Drawing.Printing.PrinterSettings();
			printDialog1.PrinterSettings = settings;
			if (printDialog1.ShowDialog(this) == DialogResult.OK)
			{

				DataSet dsPrint = new DataSet();
				DataTable dtPrint = new DataTable();
				dtPrint.Columns.Add("PatientLocation");
				dtPrint.Columns.Add("PatientName");
				dtPrint.Columns.Add("PatientID");
				dtPrint.Columns.Add("SpecimenUid");
				dtPrint.Columns.Add("Priority");
				dtPrint.Columns.Add("PrioritySort", typeof(int));
				dtPrint.Columns.Add("TestOrComponent");
				dtPrint.Columns.Add("Quantity");
				dtPrint.Columns.Add("OrderingMD");
				dtPrint.Columns.Add("Comments");
				dtPrint.Columns.Add("OrderedDate", typeof(DateTime));
				dtPrint.Columns.Add("WantedDate", typeof(DateTime));
				dtPrint.Columns.Add("TaskStatus");

				if (lvComponentPTL.CheckBoxes == true)
				{
					foreach(ListViewItem lv in this.lvComponentPTL.Items)
					{
						DataRow drComponentTask = (DataRow)lv.Tag;
						DataRow drPrint = dtPrint.NewRow();
						drPrint["PatientLocation"] = drComponentTask[Common.VbecsTables.PatientTreatment.PatientLocation];
						//CR 2667 - used BuildDispalyName method to create the name instead of building it manually
						if (drComponentTask.IsNull(Common.VbecsTables.Patient.PatientMiddleName) == false)
						{
							drPrint["PatientName"] = BOL.Patient.BuildDisplayName(drComponentTask[Common.VbecsTables.Patient.PatientFirstName].ToString(), drComponentTask[Common.VbecsTables.Patient.PatientMiddleName].ToString(), drComponentTask[Common.VbecsTables.Patient.PatientLastName].ToString());
						}
						else
						{
							drPrint["PatientName"] = BOL.Patient.BuildDisplayName(drComponentTask[Common.VbecsTables.Patient.PatientFirstName].ToString(), "", drComponentTask[Common.VbecsTables.Patient.PatientLastName].ToString());
						}
						drPrint["PatientID"] = drComponentTask[Common.VbecsTables.Patient.DisplayVistaPatientId].ToString();
						if (drComponentTask.IsNull(Common.VbecsTables.PatientSpecimen.SpecimenUid))
						{
							drPrint["SpecimenUid"] = "NRQ";
						}
						else
						{
							drPrint["SpecimenUid"] = drComponentTask[Common.VbecsTables.PatientSpecimen.SpecimenUid];
						}
						drPrint["Priority"] = drComponentTask[Common.VbecsTables.OrderUrgency.OrderUrgencyText];
						drPrint["PrioritySort"] = drComponentTask[Common.VbecsTables.OrderUrgency.SortColumn];
						drPrint["TestOrComponent"] = drComponentTask[Common.VbecsTables.ComponentClass.ComponentClassShortName];
						drPrint["Quantity"] = drComponentTask[Common.VbecsTables.OrderedComponent.RequiredUnitQuantity];
						drPrint["OrderingMD"] = drComponentTask[Common.VbecsTables.PatientOrder.OrderingProviderLastName].ToString() 
							+ ", " + drComponentTask[Common.VbecsTables.PatientOrder.OrderingProviderFirstName].ToString();
						if (drPrint["OrderingMD"].ToString().Trim() == ",")
						{
							drPrint["OrderingMD"] = "";
						}
						drPrint["Comments"] = drComponentTask[Common.VbecsTables.OrderedComponent.OrderedComponentComments];
						drPrint["OrderedDate"] = drComponentTask[Common.VbecsTables.PatientOrder.OrderPlacedDatetime];
						drPrint["WantedDate"] = drComponentTask[Common.VbecsTables.OrderedComponent.RequiredDatetime];
						drPrint["TaskStatus"] = drComponentTask[Common.VbecsTables.TaskStatus.TaskStatusText];

						dtPrint.Rows.Add(drPrint);
					}
				}

				if (lvDiagPTL.CheckBoxes == true)
				{
					foreach(ListViewItem lv in this.lvDiagPTL.Items)
					{
						DataRow drTestingTask = (DataRow)lv.Tag;
						DataRow drPrint = dtPrint.NewRow();
						drPrint["PatientLocation"] = drTestingTask[Common.VbecsTables.PatientTreatment.PatientLocation];
						//CR 2667 - used BuildDispalyName method to create the name instead of building it manually
						if (drTestingTask.IsNull(Common.VbecsTables.Patient.PatientMiddleName) == false)
						{
							drPrint["PatientName"] = BOL.Patient.BuildDisplayName(drTestingTask[Common.VbecsTables.Patient.PatientFirstName].ToString(), drTestingTask[Common.VbecsTables.Patient.PatientMiddleName].ToString(), drTestingTask[Common.VbecsTables.Patient.PatientLastName].ToString());
						}
						else
						{
							drPrint["PatientName"] = BOL.Patient.BuildDisplayName(drTestingTask[Common.VbecsTables.Patient.PatientFirstName].ToString(), "", drTestingTask[Common.VbecsTables.Patient.PatientLastName].ToString());
						}
						drPrint["PatientID"] = drTestingTask[Common.VbecsTables.Patient.DisplayVistaPatientId].ToString();
						if (drTestingTask.IsNull("SpecimenUid"))
						{
							drPrint["SpecimenUid"] = "NRQ";
						}
						else
						{
							drPrint["SpecimenUid"] = drTestingTask[Common.VbecsTables.PatientSpecimen.SpecimenUid];
						}
						drPrint["Priority"] = drTestingTask[Common.VbecsTables.OrderUrgency.OrderUrgencyText];
						drPrint["PrioritySort"] = drTestingTask[Common.VbecsTables.OrderUrgency.SortColumn];
						drPrint["TestOrComponent"] = drTestingTask[Common.VbecsTables.OrderableTest.OrderableTestName];
						drPrint["Quantity"] = "N/A";
						drPrint["OrderingMD"] = drTestingTask[Common.VbecsTables.PatientOrder.OrderingProviderLastName].ToString() 
							+ ", " + drTestingTask[Common.VbecsTables.PatientOrder.OrderingProviderFirstName].ToString();
						drPrint["Comments"] = drTestingTask[Common.VbecsTables.OrderedTest.OrderedTestComments];
						drPrint["OrderedDate"] = drTestingTask[Common.VbecsTables.PatientOrder.OrderPlacedDatetime];
						drPrint["WantedDate"] = drTestingTask[Common.VbecsTables.OrderedTest.RequiredResultsDate];
						drPrint["TaskStatus"] = drTestingTask[Common.VbecsTables.TaskStatus.TaskStatusText];

						dtPrint.Rows.Add(drPrint);
					}
				}

				dsPrint.Tables.Add(dtPrint);

#if DEBUG
                //dtPrint.WriteXml("e:\\temp\\PendingTaskListDataSet.xml", XmlWriteMode.WriteSchema);
#endif
				DataSet dsHeader =  BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
				DataSet dsFooter = BOL.VbecsReport.GetReportFooter("Tasks pending at "+ThisUser.CurrentDivisionRole.Division.DivisionName);

                ReportDataSource reportSourceMain = new ReportDataSource();
                reportSourceMain.Name = "PendingTaskListDataSet";
                reportSourceMain.Value = dtPrint;

                ReportDataSource reportSourceHeader = new ReportDataSource();
                if (dsHeader.Tables.Count > 0)
                {
                    reportSourceHeader.Name = "ReportHeaderDataSet";
                    reportSourceHeader.Value = dsHeader.Tables[0];
                }

                ReportDataSource reportSourceFooter = new ReportDataSource();
                if (dsFooter.Tables.Count > 0)
                {
                    reportSourceFooter.Name = "ReportFooterDataSet";
                    reportSourceFooter.Value = dsFooter.Tables[0];
                }

                Assembly assembly = Assembly.LoadFrom("Reports.dll");
                Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PendingTaskList.PendingTaskList.rdlc");

                LocalReport report = new LocalReport();

                report.DataSources.Add(reportSourceHeader);
                report.DataSources.Add(reportSourceFooter);
                report.DataSources.Add(reportSourceMain);
                report.LoadReportDefinition(stream);

			    using (var reportPrinter = new BOL.VbecsReportPrinter(settings, true, report))
			    {
			        reportPrinter.Print();
			    }
			}
		}

		private void btnDeselectAllDiagTests_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lstDiagTest,CheckState.Unchecked);
		}

		private void btnSelectAllDiagTests_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lstDiagTest,CheckState.Checked);
		}

		private void btnDeselectAllDiagTaskStatus_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lstDiagTaskStatus,CheckState.Unchecked);
		}

		private void btnSelectAllDiagTaskStatus_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lstDiagTaskStatus,CheckState.Checked);
		}

		private void btnDeselectAllDiagPriority_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lstDiagPriority,CheckState.Unchecked);
		}

		private void btnSelectAllDiagPriority_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lstDiagPriority,CheckState.Checked);
		}

		private void btnDeselectAllCompOrders_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lstCompOrder,CheckState.Unchecked);
		}

		private void btnSelectAllCompOrders_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lstCompOrder,CheckState.Checked);
		}

		private void btnDeselectAllCompTaskStatus_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lstCompTaskStatus,CheckState.Unchecked);
		}

		private void btnSelectAllCompTaskStatus_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lstCompTaskStatus,CheckState.Checked);
		}

		private void btnDeselectAllCompPriority_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lstCompPriority,CheckState.Unchecked);
		}

		private void btnSelectAllCompPriority_Click(object sender, System.EventArgs e)
		{
			SelectDeselectAll(this.lstCompPriority,CheckState.Checked);
		}

		private void lvDiagPTL_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 8)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvDiagPTL.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvDiagPTL.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void lvComponentPTL_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 9)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvComponentPTL.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvComponentPTL.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}		
		}

		private void btnCancelOrders_Click(object sender, System.EventArgs e)
		{
			//UC_72
			DlgCancelActiveOrderComment dlg = new DlgCancelActiveOrderComment();
			dlg.ShowDialog(this);
			if (dlg.DialogResult == DialogResult.OK)
			{
				try
				{
					Guid cannedCommentGuid = dlg.CannedCommentGuid;
					string cannedCommentText = dlg.CannedCommentText;
			
					if (this._notStartedItemsCheckedComp > 0)
					{
						DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC072.CancelActiveCompoentOrder());
						if (saveResult == DialogResult.Yes)
						{
							foreach(ListViewItem lvItm in this.lvDiagPTL.CheckedItems)
							{
								BOL.OrderedTest OrderedTestForCancel = new BOL.OrderedTest((DataRow)lvItm.Tag);
								if (OrderedTestForCancel.TaskStatusCode != Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.NotStarted) &&
									OrderedTestForCancel.TaskStatusCode != Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
									continue;

								OrderedTestForCancel.UpdateStatus(
									Common.Utility.GetOrderStatusCodeFromEnum(Common.OrderStatus.Cancelled),
									Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.Unknown),
									Common.LogonUser.LogonUserName,
									cannedCommentGuid,
									cannedCommentText,
									OrderedTestForCancel.CPRSOrderNumber,
									null,
									Common.UpdateFunction.UC072DlgCancelActiveOrderComment
									);
								this.lvDiagPTL.Items.Remove(lvItm);
								this._notStartedItemsCheckedDiag -= 1;
							}

							foreach(ListViewItem lvItm in this.lvComponentPTL.CheckedItems)
							{
								BOL.OrderedComponent OrderedComponentForCancel = new BOL.OrderedComponent((DataRow)lvItm.Tag);
								if (BOL.OrderedUnit.GetOrderedUnitCount(OrderedComponentForCancel.OrderedComponentGuid, Common.LogonUser.LogonUserDivisionCode) > 0)
									continue;

								OrderedComponentForCancel.UpdateStatus(
									Common.Utility.GetOrderStatusCodeFromEnum(Common.OrderStatus.Cancelled),
									Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.Unknown),
									Common.LogonUser.LogonUserName,
									cannedCommentGuid,
									cannedCommentText,
									false,
									null,
									Common.UpdateFunction.UC072DlgCancelActiveOrderComment);
								this.lvComponentPTL.Items.Remove(lvItm);
								this._notStartedItemsCheckedComp -= 1;
							}
						}
					}
					else
					{
						foreach(ListViewItem lvItm in this.lvDiagPTL.CheckedItems)
						{
							BOL.OrderedTest OrderedTestForCancel = new BOL.OrderedTest((DataRow)lvItm.Tag);
							if (OrderedTestForCancel.TaskStatusCode != Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.NotStarted) &&
								OrderedTestForCancel.TaskStatusCode != Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
								continue;

							OrderedTestForCancel.UpdateStatus(
								Common.Utility.GetOrderStatusCodeFromEnum(Common.OrderStatus.Cancelled),
								Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.Unknown),
								Common.LogonUser.LogonUserName,
								cannedCommentGuid,
								cannedCommentText,
								OrderedTestForCancel.CPRSOrderNumber,
								null,
								Common.UpdateFunction.UC072DlgCancelActiveOrderComment
								);
							this.lvDiagPTL.Items.Remove(lvItm);
							this._notStartedItemsCheckedDiag -= 1;
						}
					}
				}
				catch(RowVersionException)
				{
					this.btnCancelOrders.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				}
				if (this.lvComponentPTL.CheckedItems.Count + this.lvDiagPTL.CheckedItems.Count == 0)
				{
					this.btnOK.EnabledButton = false;
					this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC092.SelectAtLeastOne().ResString);
					this.btnCancelOrders.EnabledButton = false;
				}
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmPendingTaskList_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			this.SpeakMessage( this.btnOK.GetToolTip() );
		}

		private void lvDiagPTL_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvDiagPTL);
		}

		private void lvComponentPTL_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvComponentPTL);
		}


	}
}

